/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.util.ArrayList;
import java.util.HashMap;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorHelper;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.io.ExportHelper;
import net.returnvoid.tools.ProcessingTools;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;
import processing.core.PApplet;
import processing.core.PImage;
import processing.data.JSONArray;
import processing.data.JSONObject;

public class ColorPalette {
    private ColorDifferenceMeasure m;
    private ArrayList<RColor> colors = null;
    private ArrayList<String> tags = null;
    private String name = "";
    private HashMap<Integer, NumberedColor> numberedColors = new HashMap();
    private HashMap<String, QuantizeBuilder> quantizeStack = new HashMap();
    private int sum = 0;
    private Float minL = null;
    private Float maxL = null;
    private Float minC = null;
    private Float maxC = null;

    public ColorPalette() {
        this.tags = new ArrayList();
        this.colors = new ArrayList();
        this.m = ColorDifferenceMeasure.RGBEuclidean;
    }

    public ColorPalette(String jsonString) {
        String[] tags;
        this.tags = new ArrayList();
        this.colors = new ArrayList();
        this.m = ColorDifferenceMeasure.RGBEuclidean;
        JSONObject palette = JSONObject.parse((String)jsonString);
        this.setName(palette.getString("name"));
        String[] stringArray = tags = palette.getJSONArray("tags").getStringArray();
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.addTag(tag);
            ++n2;
        }
        JSONArray jsoncolors = palette.getJSONArray("colors");
        int i = 0;
        while (i < jsoncolors.size()) {
            JSONObject colorObj = jsoncolors.getJSONObject(i);
            String colorKey = (String)colorObj.keys().toArray()[0];
            JSONObject colorValues = colorObj.getJSONObject(colorKey);
            RGBColor rgb = new RGBColor(Float.valueOf(colorValues.getFloat("r")), Float.valueOf(colorValues.getFloat("g")), Float.valueOf(colorValues.getFloat("b")));
            rgb.setAlpha(Float.valueOf(colorValues.getFloat("a")));
            int importance = colorValues.getInt("importance");
            this.add(rgb, importance);
            ++i;
        }
    }

    public ColorPalette(RColor[] colors) {
        this();
        RColor c;
        this.sum = colors.length;
        RColor[] rColorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            c = rColorArray[n2];
            this.colors.add(c);
            ++n2;
        }
        rColorArray = colors;
        n = colors.length;
        n2 = 0;
        while (n2 < n) {
            c = rColorArray[n2];
            this.numberedColors.put(c.getColor(), new NumberedColor(c, 1));
            ++n2;
        }
        if (colors.length > 0) {
            this.m = colors[0].getColorSpace().toColorDifferenceMeasure();
        }
    }

    public ColorPalette(ArrayList<RColor> colors) {
        this();
        this.sum = colors.size();
        this.colors.addAll(colors);
        for (RColor c : colors) {
            this.numberedColors.put(c.getColor(), new NumberedColor(c, 1));
        }
        if (colors.size() > 0) {
            this.m = colors.get(0).getColorSpace().toColorDifferenceMeasure();
        }
    }

    public ColorPalette(int[] colors) {
        this();
        int c;
        this.sum = colors.length;
        int[] nArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            this.colors.add(RGBColor.toRGB(c));
            ++n2;
        }
        nArray = colors;
        n = colors.length;
        n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            RGBColor rgb = RGBColor.toRGB(c);
            this.numberedColors.put(c, new NumberedColor(rgb, 1));
            ++n2;
        }
    }

    public Float getMaxLuminance() {
        if (this.maxL == null) {
            ArrayList<RColor> copies = ColorHelper.copy(this.colors);
            ColorHelper.convert(copies, ColorSpace.LCHColor);
            this.maxL = Float.valueOf(RMath.max('l', copies.toArray(new RColor[copies.size()])));
        }
        return this.maxL;
    }

    public Float getMinLuminance() {
        if (this.minL == null) {
            ArrayList<RColor> copies = ColorHelper.copy(this.colors);
            ColorHelper.convert(copies, ColorSpace.LCHColor);
            this.minL = Float.valueOf(RMath.min('l', copies.toArray(new RColor[copies.size()])));
        }
        return this.minL;
    }

    public Float getMaxChroma() {
        if (this.maxC == null) {
            ArrayList<RColor> copies = ColorHelper.copy(this.colors);
            ColorHelper.convert(copies, ColorSpace.LCHColor);
            this.maxC = Float.valueOf(RMath.max('c', copies.toArray(new RColor[copies.size()])));
        }
        return this.maxC;
    }

    public Float getMinChroma() {
        if (this.minC == null) {
            ArrayList<RColor> copies = ColorHelper.copy(this.colors);
            ColorHelper.convert(copies, ColorSpace.LCHColor);
            this.minC = Float.valueOf(RMath.min('c', copies.toArray(new RColor[copies.size()])));
        }
        return this.minC;
    }

    public RColor getMostImportantColor() {
        int index = 0;
        int maxImportance = 0;
        int i = 0;
        while (i < this.colors.size()) {
            NumberedColor nc = this.numberedColors.get(this.colors.get(i).getColor());
            if (nc.importance > maxImportance) {
                index = i;
                maxImportance = nc.importance;
            }
            ++i;
        }
        return this.colors.get(index);
    }

    public ColorDifferenceMeasure getColorDifferenceMeasure() {
        return this.m;
    }

    public ColorSpace getColorSpace() {
        return this.m.toColorSpace();
    }

    private void updateSum() {
        this.sum = 0;
        for (NumberedColor c : this.numberedColors.values()) {
            this.sum += c.importance;
        }
    }

    public ColorPalette setColorSpace(ColorSpace space) {
        ColorDifferenceMeasure oldM = this.m;
        this.m = space.toColorDifferenceMeasure();
        if (oldM.toColorSpace() != space) {
            this.convertColors();
        }
        return this;
    }

    public ColorPalette setColorSpace(RColor c) {
        return this.setColorSpace(c.getColorSpace());
    }

    public ColorPalette setColorDifferenceMeasure(ColorDifferenceMeasure m) {
        ColorDifferenceMeasure oldM = this.m;
        this.m = m;
        if (oldM.toColorSpace() != m.toColorSpace()) {
            this.convertColors();
        }
        return this;
    }

    private void convertColors() {
        ColorSpace space = this.m.toColorSpace();
        ArrayList<Integer[]> keymismatch = new ArrayList<Integer[]>();
        ArrayList<RColor> keymismatchColor = new ArrayList<RColor>();
        int i = 0;
        while (i < this.colors.size()) {
            RColor oldColor = this.colors.get(i);
            RColor newColor = ColorHelper.convert(this.colors.get(i), space);
            int oldKey = oldColor.getColor();
            int newKey = newColor.getColor();
            this.colors.set(i, newColor);
            NumberedColor nc = this.numberedColors.get(oldKey);
            nc.c = newColor;
            if (oldKey != newKey) {
                keymismatch.add(new Integer[]{oldKey, newKey});
                keymismatchColor.add(newColor);
            }
            ++i;
        }
        i = 0;
        while (i < keymismatch.size()) {
            NumberedColor nc = this.numberedColors.get(((Integer[])keymismatch.get(i))[0]);
            this.numberedColors.remove(((Integer[])keymismatch.get(i))[0]);
            this.numberedColors.put(((Integer[])keymismatch.get(i))[1], nc);
            ++i;
        }
        this.maxL = null;
        this.minL = null;
        this.maxC = null;
        this.minC = null;
    }

    public float getWeighting(RColor c) {
        if (this.numberedColors.containsKey(c.getColor())) {
            return (float)this.numberedColors.get((Object)Integer.valueOf((int)c.getColor())).importance / (float)this.sum;
        }
        return 0.0f;
    }

    public ColorPalette addTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public ColorPalette addTags(String ... tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.tags.add(tag);
            ++n2;
        }
        return this;
    }

    public ColorPalette removeTag(String tag) {
        for (String t : this.tags) {
            if (!t.equals(tag)) continue;
            this.tags.remove(t);
            break;
        }
        return this;
    }

    public ArrayList<String> getTags() {
        return this.tags;
    }

    public ColorPalette setName(String name) {
        this.name = name;
        return this;
    }

    public ColorPalette removeName() {
        this.name = "";
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ColorPalette add(int c) {
        return this.add(RGBColor.toRGB(c), 1);
    }

    public ColorPalette add(int c, int importance) {
        return this.add(RGBColor.toRGB(c), importance);
    }

    public ColorPalette add(RColor c) {
        return this.add(c, 1);
    }

    public ColorPalette add(RColor c, int importance) {
        if (!this.numberedColors.containsKey(c.getColor())) {
            if (importance < 1) {
                importance = 1;
            }
            if (this.colors.size() == 0) {
                this.m = c.getColorSpace().toColorDifferenceMeasure();
            }
            this.maxL = null;
            this.minL = null;
            this.maxC = null;
            this.minC = null;
            this.colors.add(c);
            this.numberedColors.put(c.getColor(), new NumberedColor(c, importance));
            this.updateSum();
        }
        return this;
    }

    public ColorPalette resetImportance() {
        for (RColor c : this.colors) {
            NumberedColor nc = this.numberedColors.get(c.getColor());
            nc.importance = 1;
            this.updateSum();
        }
        return this;
    }

    public ColorPalette increaseImportance(RColor c, int howMuch) {
        if (this.numberedColors.containsKey(c) && howMuch > 0) {
            NumberedColor nc = this.numberedColors.get(c);
            nc.importance += RMath.abs(howMuch);
            this.updateSum();
        }
        return this;
    }

    public ColorPalette applyImportance(RColor c, int importance) {
        return this.applyImportance(c.getColor(), importance);
    }

    public ColorPalette applyImportance(int c, int importance) {
        if (this.numberedColors.containsKey(c) && importance > 0) {
            NumberedColor nc = this.numberedColors.get(c);
            nc.importance = importance;
            this.updateSum();
        }
        return this;
    }

    public ColorPalette applyImportance(int[] importances) {
        int i = 0;
        while (i < importances.length && i < this.colors.size()) {
            RColor c = this.colors.get(i);
            NumberedColor nc = this.numberedColors.get(c.getColor());
            if (importances[i] > 0) {
                nc.importance = importances[i];
            }
            ++i;
        }
        this.updateSum();
        return this;
    }

    public ColorPalette remove(RColor c) {
        if (this.numberedColors.containsKey(c.getColor())) {
            this.maxL = null;
            this.minL = null;
            this.maxC = null;
            this.minC = null;
            this.numberedColors.remove(c.getColor());
            this.colors.remove(c);
            this.updateSum();
        }
        return this;
    }

    public ColorPalette remove(int c) {
        if (this.numberedColors.containsKey(c)) {
            return this.remove(this.numberedColors.get((Object)Integer.valueOf((int)c)).c);
        }
        return this;
    }

    public ColorPalette merge(ColorPalette other) {
        int i = 0;
        while (i < other.size()) {
            RColor otherColor = other.get(i);
            int otherImportance = other.numberedColors.get((Object)Integer.valueOf((int)otherColor.getColor())).importance;
            if (this.numberedColors.containsKey(otherColor.getColor())) {
                this.increaseImportance(this.numberedColors.get((Object)Integer.valueOf((int)otherColor.getColor())).c, otherImportance);
            } else {
                this.add(otherColor, otherImportance);
            }
            ++i;
        }
        return this;
    }

    public ColorPalette sort() {
        return this.sort("luminance");
    }

    public ColorPalette sort(String how) {
        how = how.toLowerCase();
        int mode = 0;
        mode = how.equals("luminance") ? 0 : (how.equals("hue") ? 1 : (how.equals("chroma") ? 2 : (how.equals("brightness") ? 3 : (how.equals("saturation") ? 4 : (how.equals("red") ? 5 : (how.equals("green") ? 6 : (how.equals("blue") ? 7 : (how.equals("weighting") ? 8 : 9))))))));
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            int i = 0;
            while (i < this.colors.size() - 1) {
                Float val1 = Float.valueOf(0.0f);
                Float val2 = Float.valueOf(0.0f);
                switch (mode) {
                    case 0: {
                        val1 = Float.valueOf(this.colors.get(i).toLab().getLuminance());
                        val2 = Float.valueOf(this.colors.get(i + 1).toLab().getLuminance());
                        break;
                    }
                    case 1: {
                        val1 = this.colors.get(i).toHSB().getHue();
                        val2 = this.colors.get(i + 1).toHSB().getHue();
                        break;
                    }
                    case 2: {
                        val1 = this.colors.get(i).toLab().getChroma();
                        val2 = this.colors.get(i + 1).toLab().getChroma();
                        break;
                    }
                    case 3: {
                        val1 = this.colors.get(i).toHSB().getBrightness();
                        val2 = this.colors.get(i + 1).toHSB().getBrightness();
                        break;
                    }
                    case 4: {
                        val1 = this.colors.get(i).toHSB().getSaturation();
                        val2 = this.colors.get(i + 1).toHSB().getSaturation();
                        break;
                    }
                    case 5: {
                        val1 = this.colors.get(i).toRGB().getRed();
                        val2 = this.colors.get(i + 1).toRGB().getRed();
                        break;
                    }
                    case 6: {
                        val1 = this.colors.get(i).toRGB().getGreen();
                        val2 = this.colors.get(i + 1).toRGB().getGreen();
                        break;
                    }
                    case 7: {
                        val1 = this.colors.get(i).toRGB().getBlue();
                        val2 = this.colors.get(i + 1).toRGB().getBlue();
                        break;
                    }
                    case 8: {
                        val1 = Float.valueOf(this.getWeighting(this.colors.get(i)));
                        val2 = Float.valueOf(this.getWeighting(this.colors.get(i + 1)));
                        break;
                    }
                    case 9: {
                        val1 = this.colors.get(i).toLCH().getHue();
                        val2 = this.colors.get(i + 1).toLCH().getHue();
                        break;
                    }
                    default: {
                        val1 = Float.valueOf(this.colors.get(i).toLab().getLuminance());
                        val2 = Float.valueOf(this.colors.get(i + 1).toLab().getLuminance());
                    }
                }
                if (val1.floatValue() < val2.floatValue()) {
                    RColor tmp = this.colors.get(i);
                    this.colors.set(i, this.colors.get(i + 1));
                    this.colors.set(i + 1, tmp);
                    sorted = false;
                }
                ++i;
            }
        }
        return this;
    }

    public ColorPalette copy() {
        ColorPalette copy = new ColorPalette();
        copy.m = this.m;
        copy.maxC = this.maxC != null ? new Float(this.maxC.floatValue()) : null;
        copy.maxL = this.maxL != null ? new Float(this.maxL.floatValue()) : null;
        copy.minC = this.minC != null ? new Float(this.minC.floatValue()) : null;
        copy.minL = this.minL != null ? new Float(this.minL.floatValue()) : null;
        copy.name = new String(this.name);
        for (String tag : this.tags) {
            copy.tags.add(new String(tag));
        }
        for (RColor color : this.colors) {
            copy.add(color.copy());
            copy.applyImportance(color.getColor(), this.numberedColors.get((Object)Integer.valueOf((int)color.getColor())).importance);
        }
        return copy;
    }

    public ColorPalette reduceSize(int size) {
        if ((size = RMath.abs(size)) < 1) {
            size = 1;
        }
        while (this.size() > size) {
            HashMap<String, Float> indexToDiffMap = new HashMap<String, Float>();
            float diff = 0.0f;
            float minDiff = 100000.0f;
            int minDiffIndex = 0;
            int i = 0;
            while (i < this.colors.size()) {
                diff = 0.0f;
                minDiff = 10000.0f;
                minDiffIndex = 0;
                int j = i + 1;
                while (j < this.colors.size()) {
                    diff = ColorDifference.difference(this.colors.get(i), this.colors.get(j), this.m).floatValue();
                    if (diff < minDiff) {
                        minDiff = diff;
                        minDiffIndex = j;
                    }
                    ++j;
                }
                String key = String.valueOf(i) + "," + minDiffIndex;
                indexToDiffMap.put(key, Float.valueOf(minDiff));
                ++i;
            }
            minDiff = 100000.0f;
            String minDiffKey = "";
            for (String key : indexToDiffMap.keySet()) {
                if (!(((Float)indexToDiffMap.get(key)).floatValue() < minDiff)) continue;
                minDiffKey = key;
                minDiff = ((Float)indexToDiffMap.get(key)).floatValue();
            }
            String[] indexes = minDiffKey.split(",");
            int index1 = Integer.parseInt(indexes[0]);
            int index2 = Integer.parseInt(indexes[1]);
            RColor mergedColor = ColorHelper.getMeanColor(this.m, this.colors.get(index1), this.colors.get(index2));
            int sumOfMergedColor = this.numberedColors.get((Object)Integer.valueOf((int)this.colors.get((int)index1).getColor())).importance + this.numberedColors.get((Object)Integer.valueOf((int)this.colors.get((int)index2).getColor())).importance;
            this.remove(this.colors.get(index2));
            this.remove(this.colors.get(index1));
            this.add(mergedColor, sumOfMergedColor);
        }
        return this;
    }

    public int size() {
        return this.colors.size();
    }

    public RColor getRandom() {
        if (this.colors.size() == 0) {
            return null;
        }
        return this.colors.get(RMath.random(this.colors.size()));
    }

    public RColor getRandomWeighted() {
        if (this.sum == this.colors.size()) {
            return this.getRandom();
        }
        float rval = RMath.random((float)this.sum);
        int importanceSum = 0;
        RColor foundColor = null;
        for (Integer key : this.numberedColors.keySet()) {
            NumberedColor nc = this.numberedColors.get(key);
            if ((float)importanceSum <= rval && rval < (float)(importanceSum + nc.importance)) {
                foundColor = nc.c;
                break;
            }
            importanceSum += nc.importance;
        }
        if (foundColor == null) {
            foundColor = this.getRandom();
        }
        return foundColor;
    }

    public RColor getDithered(RColor c, float dithering) {
        if ((dithering = (float)((double)dithering * 0.95)) < 0.0f) {
            return this.get(c);
        }
        if ((double)dithering > 0.95) {
            dithering = 0.95f;
        }
        float lowestDist = 1.0E7f;
        float secondLowestDist = 1.0E7f;
        float hightestDist = 0.0f;
        int lowestDistIndex = 0;
        int secondLowestDistIndex = 0;
        float diff = 0.0f;
        int i = 0;
        while (i < this.colors.size()) {
            diff = ColorDifference.difference(c, this.colors.get(i), this.m).floatValue();
            if (diff < lowestDist) {
                lowestDist = diff;
                lowestDistIndex = i;
            } else if (diff < secondLowestDist) {
                secondLowestDist = diff;
                secondLowestDistIndex = i;
            }
            if (diff > hightestDist) {
                hightestDist = diff;
            }
            ++i;
        }
        float firstRange = secondLowestDist - lowestDist;
        float range = hightestDist - lowestDist;
        float meanRange = range / (float)(this.colors.size() - 1);
        float amt = 1.0f - firstRange / meanRange;
        float rand = RMath.random(0.0f, amt);
        return rand <= 1.0f - dithering ? this.colors.get(lowestDistIndex) : this.colors.get(secondLowestDistIndex);
    }

    public String getDithered(PImage img, float dithering) {
        int threadsNum = img.pixels.length / 30000;
        threadsNum = RMath.constrain(threadsNum, 4, 30);
        QuantizeBuilder builder = new QuantizeBuilder(img, threadsNum, 1, dithering);
        return builder.timestamp;
    }

    public RColor getNoisy(RColor c, float amt) {
        if (amt < 0.0f) {
            return this.get(c);
        }
        int index = ColorDifference.getMostSimilarColor(c, this.colors, this.m);
        RColor c1 = index == -1 ? this.getRandom() : this.colors.get(index);
        int index2 = ColorDifference.getMostSimilarColor(c1, this.colors, true, this.m);
        RColor c2 = index2 == -1 ? this.getRandom() : this.colors.get(index2);
        float diff1 = ColorDifference.difference(c, c1, this.m).floatValue();
        float diff2 = ColorDifference.difference(c, c2, this.m).floatValue();
        float abs = RMath.abs(diff1 - diff2);
        float startDiff = diff1 - abs * amt;
        float r1 = RMath.random(startDiff, diff1);
        float r2 = RMath.random(startDiff, diff2);
        return r1 > r2 ? c2 : c1;
    }

    public String getNoisy(PImage img, float amt) {
        int threadsNum = img.pixels.length / 30000;
        threadsNum = RMath.constrain(threadsNum, 4, 30);
        QuantizeBuilder builder = new QuantizeBuilder(img, threadsNum, 2, amt);
        return builder.timestamp;
    }

    public RColor get(RColor c) {
        if (this.colors.size() == 0) {
            return null;
        }
        int index = ColorDifference.getMostSimilarColor(c, this.colors, this.m);
        if (index == -1) {
            return this.getRandom();
        }
        return this.colors.get(index);
    }

    public String get(PImage img) {
        int threadsNum = img.pixels.length / 30000;
        threadsNum = RMath.constrain(threadsNum, 4, 30);
        QuantizeBuilder builder = new QuantizeBuilder(img, threadsNum);
        return builder.timestamp;
    }

    public RColor get(int index) {
        if (index < 0 || index >= this.colors.size()) {
            return null;
        }
        return this.colors.get(index);
    }

    public RColor find(float tplusi) {
        int i = (int)tplusi;
        if (i < 0) {
            i = 0;
        } else if (i >= this.colors.size() - 1) {
            i = this.colors.size() - 2;
        }
        float amt = tplusi - (float)i;
        return ColorHelper.lerpColors(this.colors.get(i), this.colors.get(i + 1), amt);
    }

    public int getIndex(RColor c) {
        int index = ColorDifference.getMostSimilarColor(c, this.colors, this.m);
        return index;
    }

    public boolean finishedImage(String timestamp) {
        return !this.quantizeStack.containsKey(timestamp);
    }

    private String getColorString(RColor c) {
        String txt = "{";
        RGBColor rgb = c.toRGB();
        txt = String.valueOf(txt) + StringTools.getStringEcp(rgb.getOpHexString()) + " : {";
        txt = String.valueOf(txt) + StringTools.getKeyValue("r", "" + rgb.getRed()) + ",";
        txt = String.valueOf(txt) + StringTools.getKeyValue("g", "" + rgb.getGreen()) + ",";
        txt = String.valueOf(txt) + StringTools.getKeyValue("b", "" + rgb.getBlue()) + ",";
        txt = String.valueOf(txt) + StringTools.getKeyValue("a", "" + rgb.getAlpha()) + ",";
        txt = String.valueOf(txt) + StringTools.getKeyValue("importance", String.valueOf(this.numberedColors.get((Object)Integer.valueOf((int)c.getColor())).importance));
        txt = String.valueOf(txt) + "}}";
        return txt;
    }

    private String getColorStrings(ArrayList<RColor> colors) {
        String txt = "[";
        for (RColor c : colors) {
            txt = String.valueOf(txt) + this.getColorString(c) + ",";
        }
        return String.valueOf(txt.substring(0, txt.length() - 1)) + "]";
    }

    public ColorPalette save(PApplet parent) {
        return this.save(String.valueOf(ProcessingTools.getSketchPath(parent)) + "\\export");
    }

    public ColorPalette save(PApplet parent, String folder) {
        return this.save(String.valueOf(ProcessingTools.getSketchPath(parent)) + "\\" + folder);
    }

    public ColorPalette save(PApplet parent, String folder, String name) {
        return this.save(String.valueOf(ProcessingTools.getSketchPath(parent)) + "\\" + folder, name);
    }

    public ColorPalette save(String path) {
        String filename = "";
        filename = this.name == null || this.name.length() == 0 ? String.valueOf(StringTools.timestamp()) + "_" + this.colors.size() : String.valueOf(this.name) + "_" + this.colors.size();
        return this.save(path, filename);
    }

    public ColorPalette save(String path, String name) {
        name = String.valueOf(name) + ".color.json";
        String tagKey = StringTools.getKeyValue("tags", this.tags);
        String nameKey = StringTools.getKeyValue("name", this.name);
        String colorKey = StringTools.getKeyValue("colors", this.getColorStrings(this.colors), false);
        String jsonString = "{" + StringTools.join(",", nameKey, tagKey, colorKey) + "}";
        String reply = ExportHelper.writeTextFile(path, name, jsonString);
        if (reply != null) {
            System.err.println(reply);
        }
        return this;
    }

    public ColorPalette draw(PApplet parent, float x, float y, float w, float h) {
        parent.pushStyle();
        float cpx = x;
        parent.noStroke();
        for (RColor c : this.colors) {
            float weighting = this.getWeighting(c);
            float cpw = w * weighting;
            parent.fill(c.getColor());
            parent.rect(cpx - 0.5f, y, cpw + 1.0f, h);
            cpx += cpw;
        }
        parent.popStyle();
        return this;
    }

    public int[] toColors() {
        int[] colors = new int[this.colors.size()];
        int i = 0;
        while (i < colors.length) {
            colors[i] = this.colors.get(i).getColor();
            ++i;
        }
        return colors;
    }

    public RColor[] getColors() {
        return this.colors.toArray(new RColor[this.colors.size()]);
    }

    public String toString() {
        String txt = "name: " + this.name + "\n";
        txt = String.valueOf(txt) + "tags: " + (this.tags.size() > 0 ? StringTools.join(this.tags, ", ") : "") + "\n";
        for (Integer key : this.numberedColors.keySet()) {
            txt = String.valueOf(txt) + "[" + this.getWeighting(this.numberedColors.get((Object)key).c) + "] " + this.numberedColors.get(key) + "\n";
        }
        return txt;
    }

    private class NumberedColor {
        int importance;
        RColor c;

        private NumberedColor(RColor c, int importance) {
            this.c = c;
            this.importance = importance;
        }

        private NumberedColor(RColor c) {
            this(c, 1);
        }

        public String toString() {
            return String.valueOf(this.importance) + "x " + this.c;
        }
    }

    private class QuantizeBuilder
    extends Thread {
        private String timestamp = String.valueOf(StringTools.timestamp()) + "_" + StringTools.nf(RMath.random(1000), 4);
        private PImage img;
        private Integer threads;
        private Integer method;
        private Float dithering;

        public QuantizeBuilder(PImage img, int threads, int method, float amt) {
            this.threads = threads;
            this.img = img;
            this.method = method;
            this.dithering = Float.valueOf(amt);
            ColorPalette.this.quantizeStack.put(this.timestamp, this);
            this.start();
        }

        public QuantizeBuilder(PImage img, int threads) {
            this(img, threads, 0, 0.0f);
        }

        @Override
        public void run() {
            this.img.loadPixels();
            int steps = this.img.pixels.length / this.threads;
            ArrayList<PartialQuantizeBuilder> builders = new ArrayList<PartialQuantizeBuilder>(steps);
            int i = 0;
            while (i < this.threads) {
                Integer startRange = i * steps;
                Integer endRange = startRange + steps;
                if (i == this.threads - 1) {
                    endRange = this.img.pixels.length - 1;
                }
                builders.add(new PartialQuantizeBuilder(this.img, this.method, this.dithering.floatValue(), startRange, endRange));
                ++i;
            }
            boolean running = true;
            block3: while (running) {
                running = false;
                for (PartialQuantizeBuilder b : builders) {
                    if (b.getState() == Thread.State.TERMINATED) continue;
                    running = true;
                    try {
                        this.wait(300L);
                    }
                    catch (Exception exception) {}
                    continue block3;
                }
            }
            builders.clear();
            builders = null;
            ColorPalette.this.quantizeStack.remove(this.timestamp);
        }

        private class PartialQuantizeBuilder
        extends Thread {
            private PImage img;
            private Integer method;
            private Float dithering;
            private Integer startRange;
            private Integer endRange;

            public PartialQuantizeBuilder(PImage img, int method, float amt, Integer startRange, Integer endRange) {
                this.startRange = startRange;
                this.endRange = endRange;
                this.img = img;
                this.method = method;
                this.dithering = Float.valueOf(amt);
                this.start();
            }

            @Override
            public void run() {
                RGBColor rgb = new RGBColor(0.0f);
                int steps = 4;
                int range = (this.endRange - this.startRange) / steps;
                int i = 0;
                while (i < steps) {
                    int start = this.startRange + range * i;
                    int end = start + range - 1;
                    if (i == steps - 1) {
                        end = this.endRange;
                    }
                    int j = start;
                    while (j <= end) {
                        rgb.set(this.img.pixels[j]);
                        this.img.pixels[j] = this.method == 0 ? ColorPalette.this.get(rgb).getColor() : (this.method == 1 ? ColorPalette.this.getDithered(rgb, this.dithering.floatValue()).getColor() : ColorPalette.this.getNoisy(rgb, this.dithering.floatValue()).getColor());
                        ++j;
                    }
                    this.img.updatePixels();
                    ++i;
                }
            }
        }
    }
}

