/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.util.ArrayList;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.HSBColor;
import net.returnvoid.color.LCHColor;
import net.returnvoid.color.LabColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.color.XYZColor;
import net.returnvoid.tools.RMath;

public class ColorHelper {
    private ColorHelper() {
    }

    public static RColor[] copy(RColor[] colors) {
        RColor[] copies = new RColor[colors.length];
        int i = 0;
        while (i < copies.length) {
            copies[i] = colors[i].copy();
            ++i;
        }
        return copies;
    }

    public static ArrayList<RColor> copy(ArrayList<RColor> colors) {
        ArrayList<RColor> copies = new ArrayList<RColor>(colors.size());
        int i = 0;
        while (i < colors.size()) {
            copies.add(colors.get(i).copy());
            ++i;
        }
        return copies;
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m) {
        return ColorHelper.getLoss(rvMean, colors, null, m, 0, colors.length);
    }

    public static Float getLoss(RColor rvMean, RColor[] colors, ColorDifferenceMeasure m, int start, int end) {
        return ColorHelper.getLoss(rvMean, colors, null, m, start, end);
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> colors, ColorDifferenceMeasure m) {
        return ColorHelper.getLoss(rvMean, null, colors, m, 0, colors.size());
    }

    public static Float getLoss(RColor rvMean, ArrayList<RColor> colors, ColorDifferenceMeasure m, int start, int end) {
        return ColorHelper.getLoss(rvMean, null, colors, m, start, end);
    }

    private static Float getLoss(RColor rvMean, RColor[] aColors, ArrayList<RColor> lColors, ColorDifferenceMeasure m, int start, int end) {
        ColorSpace space = m.toColorSpace();
        float loss = 0.0f;
        switch (space) {
            case HSBColor: {
                if (aColors != null) {
                    loss = HSBColor.getLoss(rvMean, aColors, m, start, end).floatValue();
                    break;
                }
                loss = HSBColor.getLoss(rvMean, lColors, m, start, end).floatValue();
                break;
            }
            case LabColor: {
                if (aColors != null) {
                    loss = LabColor.getLoss(rvMean, aColors, m, start, end).floatValue();
                    break;
                }
                loss = LabColor.getLoss(rvMean, lColors, m, start, end).floatValue();
                break;
            }
            case LCHColor: {
                if (aColors != null) {
                    loss = LCHColor.getLoss(rvMean, aColors, m, start, end).floatValue();
                    break;
                }
                loss = LCHColor.getLoss(rvMean, lColors, m, start, end).floatValue();
                break;
            }
            case XYZColor: {
                if (aColors != null) {
                    loss = XYZColor.getLoss(rvMean, aColors, m, start, end).floatValue();
                    break;
                }
                loss = XYZColor.getLoss(rvMean, lColors, m, start, end).floatValue();
                break;
            }
            default: {
                loss = aColors != null ? RGBColor.getLoss(rvMean, aColors, m, start, end).floatValue() : RGBColor.getLoss(rvMean, lColors, m, start, end).floatValue();
            }
        }
        return Float.valueOf(loss);
    }

    public static RColor getMeanColor(ColorDifferenceMeasure m, RColor ... colors) {
        return ColorHelper.getMeanColor(colors, null, m.toColorSpace());
    }

    public static RColor getMeanColor(RColor[] colors, ColorDifferenceMeasure m) {
        return ColorHelper.getMeanColor(colors, null, m.toColorSpace());
    }

    public static RColor getMeanColor(ArrayList<RColor> colors, ColorDifferenceMeasure m) {
        return ColorHelper.getMeanColor(null, colors, m.toColorSpace());
    }

    public static RColor getMeanColor(RColor[] colors, ColorSpace space) {
        return ColorHelper.getMeanColor(colors, null, space);
    }

    public static RColor getMeanColor(ArrayList<RColor> colors, ColorSpace space) {
        return ColorHelper.getMeanColor(null, colors, space);
    }

    private static RColor getMeanColor(RColor[] aColors, ArrayList<RColor> lColors, ColorSpace space) {
        RColor mean = null;
        switch (space) {
            case HSBColor: {
                if (aColors != null) {
                    mean = HSBColor.getMeanColor(aColors);
                    break;
                }
                mean = HSBColor.getMeanColor(lColors);
                break;
            }
            case LabColor: {
                if (aColors != null) {
                    mean = LabColor.getMeanColor(aColors);
                    break;
                }
                mean = LabColor.getMeanColor(lColors);
                break;
            }
            case LCHColor: {
                if (aColors != null) {
                    mean = LCHColor.getMeanColor(aColors);
                    break;
                }
                mean = LCHColor.getMeanColor(lColors);
                break;
            }
            case XYZColor: {
                if (aColors != null) {
                    mean = XYZColor.getMeanColor(aColors);
                    break;
                }
                mean = XYZColor.getMeanColor(lColors);
                break;
            }
            default: {
                mean = aColors != null ? RGBColor.getMeanColor(aColors) : RGBColor.getMeanColor(lColors);
            }
        }
        return mean;
    }

    public static RColor lerpColors(RColor c1, RColor c2, float amt) {
        RColor newC;
        ColorSpace target = c1.getColorSpace();
        switch (target) {
            case HSBColor: {
                newC = HSBColor.lerpColors(c1, c2, amt);
                break;
            }
            case LabColor: {
                newC = LabColor.lerpColors(c1, c2, amt);
                break;
            }
            case LCHColor: {
                newC = LCHColor.lerpColors(c1, c2, amt);
                break;
            }
            case XYZColor: {
                newC = XYZColor.lerpColors(c1, c2, amt);
                break;
            }
            default: {
                newC = RGBColor.lerpColors(c1, c2, amt);
            }
        }
        return newC;
    }

    public static RColor convert(RColor c, ColorSpace target) {
        RColor newC;
        switch (target) {
            case HSBColor: {
                newC = c.toHSB();
                break;
            }
            case LabColor: {
                newC = c.toLab();
                break;
            }
            case LCHColor: {
                newC = c.toLCH();
                break;
            }
            case XYZColor: {
                newC = c.toXYZ();
                break;
            }
            default: {
                newC = c.toRGB();
            }
        }
        return newC;
    }

    public static RColor convert(RColor c, ColorDifferenceMeasure m) {
        return ColorHelper.convert(c, m.toColorSpace());
    }

    public static void convert(RColor[] colors, ColorSpace target) {
        ColorHelper.convert(colors, null, target);
    }

    public static void convert(ArrayList<RColor> colors, ColorSpace target) {
        ColorHelper.convert(null, colors, target);
    }

    private static void convert(RColor[] cA, ArrayList<RColor> cL, ColorSpace target) {
        int max = cA != null ? cA.length : cL.size();
        int i = 0;
        while (i < max) {
            RColor converted = ColorHelper.convert(cA != null ? cA[i] : cL.get(i), target);
            if (cA != null) {
                cA[i] = converted;
            } else {
                cL.set(i, converted);
            }
            ++i;
        }
    }

    public static boolean contains(RColor ref, RColor[] colors) {
        return ColorHelper.contains(ref, colors, null);
    }

    public static boolean contains(RColor ref, ArrayList<RColor> colors) {
        return ColorHelper.contains(ref, null, colors);
    }

    private static boolean contains(RColor ref, RColor[] aColors, ArrayList<RColor> lColors) {
        if (ref == null) {
            return false;
        }
        int max = aColors != null ? aColors.length : lColors.size();
        int i = 0;
        while (i < max) {
            RColor tmp;
            RColor rColor = tmp = aColors != null ? aColors[i] : lColors.get(i);
            if (tmp != null && ref.equals(tmp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int getRandomColor() {
        return 0xFF000000 | RMath.random(0, 256) << 16 | RMath.random(0, 256) << 8 | RMath.random(0, 256);
    }

    public static int getColor(String hex) {
        String alpha;
        String rgb;
        if ((hex = hex.replaceAll("[^0-9a-fA-F]", "")).length() == 8) {
            rgb = hex.substring(hex.length() - 6, hex.length());
            alpha = hex.substring(hex.length() - 8, hex.length() - 6);
        } else if (hex.length() == 6) {
            rgb = hex;
            alpha = "FF";
        } else {
            System.err.println(String.valueOf(hex) + " is no valid hexadecimal color");
            return -16777216;
        }
        return Integer.parseInt(alpha, 16) << 24 | Integer.parseInt(rgb, 16);
    }

    public static int getColor(float ... paramters) {
        float a;
        float r;
        float g;
        float b;
        if (paramters.length == 0) {
            b = 0.0f;
            g = 0.0f;
            r = 0.0f;
            a = 255.0f;
        } else if (paramters.length == 1) {
            g = b = paramters[0];
            r = b;
            a = 255.0f;
        } else if (paramters.length == 2) {
            g = b = paramters[0];
            r = b;
            a = paramters[1];
        } else if (paramters.length == 3) {
            r = paramters[0];
            g = paramters[1];
            b = paramters[2];
            a = 255.0f;
        } else {
            r = paramters[0];
            g = paramters[1];
            b = paramters[2];
            a = paramters[3];
        }
        int intA = RMath.constrain((int)a, 0, 255);
        int intR = RMath.constrain((int)r, 0, 255);
        int intG = RMath.constrain((int)g, 0, 255);
        int intB = RMath.constrain((int)b, 0, 255);
        return intA << 24 | intR << 16 | intG << 8 | intB;
    }
}

