/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.color;

import java.util.ArrayList;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorHelper;
import net.returnvoid.color.HSBColor;
import net.returnvoid.color.LCHColor;
import net.returnvoid.color.LabColor;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.color.XYZColor;

public class ColorDifference {
    public static float weightingLuminance = 1.0f;
    public static float weightingChroma = 1.0f;
    public static float weightingHue = 1.0f;

    private ColorDifference() {
    }

    public static Integer getMostSimilarColor(RColor base, RColor[] targets, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostSimilarColor(base, targets, null, false, measure);
    }

    public static Integer getMostSimilarColor(RColor base, RColor[] targets, boolean ignoreSelf, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostSimilarColor(base, targets, null, ignoreSelf, measure);
    }

    public static Integer getMostSimilarColor(RColor base, ArrayList<RColor> targets, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostSimilarColor(base, null, targets, false, measure);
    }

    public static Integer getMostSimilarColor(RColor base, ArrayList<RColor> targets, boolean ignoreSelf, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostSimilarColor(base, null, targets, ignoreSelf, measure);
    }

    private static Integer getMostSimilarColor(RColor base, RColor[] aTargets, ArrayList<RColor> lTargets, boolean ignoreSelf, ColorDifferenceMeasure measure) {
        if (aTargets != null && aTargets.length == 0 || lTargets != null && lTargets.size() == 0) {
            return -1;
        }
        int index = -1;
        float minDiff = 1.0E7f;
        int max = aTargets != null ? aTargets.length : lTargets.size();
        int i = 0;
        while (i < max) {
            float diff;
            RColor target;
            RColor rColor = target = aTargets != null ? aTargets[i] : lTargets.get(i);
            if (!(target == null || ignoreSelf && base.equals(target) || !((diff = ColorDifference.difference(base, target, measure).floatValue()) < minDiff))) {
                index = i;
                minDiff = diff;
            }
            ++i;
        }
        return index;
    }

    public static Integer getMostDifferentColor(RColor base, RColor[] targets, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostDifferentColor(new RColor[]{base}, targets, measure);
    }

    public static Integer getMostDifferentColor(RColor base, ArrayList<RColor> targets, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostDifferentColor(new RColor[]{base}, targets, measure);
    }

    public static Integer getMostDifferentColor(RColor[] bases, ArrayList<RColor> targets, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostDifferentColor(bases, null, targets, measure);
    }

    public static Integer getMostDifferentColor(RColor[] bases, RColor[] targets, ColorDifferenceMeasure measure) {
        return ColorDifference.getMostDifferentColor(bases, targets, null, measure);
    }

    private static Integer getMostDifferentColor(RColor[] bases, RColor[] aTargets, ArrayList<RColor> lTargets, ColorDifferenceMeasure measure) {
        if (aTargets != null && aTargets.length == 0 || lTargets != null && lTargets.size() == 0) {
            return -1;
        }
        int index = -1;
        float maxDiff = -1.0f;
        int max = aTargets != null ? aTargets.length : lTargets.size();
        int i = 0;
        while (i < max) {
            RColor target;
            float summedDiff = 0.0f;
            RColor rColor = target = aTargets != null ? aTargets[i] : lTargets.get(i);
            if (target != null) {
                int j = 0;
                while (j < bases.length) {
                    if (bases[j] != null && !bases[j].equals(target)) {
                        summedDiff += ColorDifference.difference(bases[j], target, measure).floatValue();
                    }
                    ++j;
                }
                if (summedDiff > maxDiff && !ColorHelper.contains(target, bases)) {
                    index = i;
                    maxDiff = summedDiff;
                }
            }
            ++i;
        }
        return index;
    }

    public static Float difference(int color1, int color2) {
        return ColorDifference.difference(RGBColor.toRGB(color1), RGBColor.toRGB(color2), ColorDifferenceMeasure.RGBEuclidean);
    }

    public static Float difference(RColor color1, RColor color2) {
        return ColorDifference.difference(color1, color2, color1.getColorSpace().toColorDifferenceMeasure());
    }

    public static Float difference(RColor color1, RColor color2, ColorDifferenceMeasure measure) {
        Float diff = Float.valueOf(0.0f);
        switch (measure) {
            case RGB2R4G3B: {
                diff = ColorDifference.rgbWeighted(color1, color2);
                break;
            }
            case RGBMeanRed: {
                diff = ColorDifference.rgbMeanRed(color1, color2);
                break;
            }
            case HSBEuclidean: {
                diff = ColorDifference.hsbEuclidean(color1, color2);
                break;
            }
            case HSBCylinder: {
                diff = ColorDifference.hsbCylinder(color1, color2);
                break;
            }
            case HSBCone: {
                diff = ColorDifference.hsbCone(color1, color2);
                break;
            }
            case LabDeltaE: {
                diff = ColorDifference.labDeltaE(color1, color2);
                break;
            }
            case LabDeltaE1994: {
                diff = ColorDifference.labDeltaE1994(color1, color2);
                break;
            }
            case LabDeltaE2000: {
                diff = ColorDifference.labDeltaE2000(color1, color2);
                break;
            }
            case LCHEuclidean: {
                diff = ColorDifference.lchEuclidean(color1, color2);
                break;
            }
            case LCHCMC: {
                diff = ColorDifference.lchCMC(color1, color2);
                break;
            }
            case XYZEuclidean: {
                diff = ColorDifference.xyzEuclidean(color1, color2);
                break;
            }
            default: {
                diff = ColorDifference.rgbEuclidean(color1, color2);
            }
        }
        return diff;
    }

    public static Float rgbEuclidean(RColor color1, RColor color2) {
        RGBColor rgb1 = color1.toRGB();
        RGBColor rgb2 = color2.toRGB();
        return Float.valueOf((float)Math.pow(Math.pow(rgb1.getRed().floatValue() - rgb2.getRed().floatValue(), 2.0) + Math.pow(rgb1.getGreen().floatValue() - rgb2.getGreen().floatValue(), 2.0) + Math.pow(rgb1.getBlue().floatValue() - rgb2.getBlue().floatValue(), 2.0), 0.5));
    }

    public static Float rgbWeighted(RColor color1, RColor color2) {
        RGBColor rgb1 = color1.toRGB();
        RGBColor rgb2 = color2.toRGB();
        return Float.valueOf((float)Math.pow(2.0 * Math.pow(rgb1.getRed().floatValue() - rgb2.getRed().floatValue(), 2.0) + 4.0 * Math.pow(rgb1.getGreen().floatValue() - rgb2.getGreen().floatValue(), 2.0) + 3.0 * Math.pow(rgb1.getBlue().floatValue() - rgb2.getBlue().floatValue(), 2.0), 0.5));
    }

    public static Float rgbMeanRed(RColor color1, RColor color2) {
        RGBColor rgb1 = color1.toRGB();
        RGBColor rgb2 = color2.toRGB();
        float meanRed = 0.5f * (rgb1.getRed().floatValue() + rgb2.getRed().floatValue());
        float deltaR = rgb1.getRed().floatValue() - rgb2.getRed().floatValue();
        float deltaG = rgb1.getGreen().floatValue() - rgb2.getGreen().floatValue();
        float deltaB = rgb1.getBlue().floatValue() - rgb2.getBlue().floatValue();
        return Float.valueOf((float)Math.pow((double)(2.0f + meanRed / 256.0f) * Math.pow(deltaR, 2.0) + 4.0 * Math.pow(deltaG, 2.0) + (double)(2.0f + (255.0f - meanRed) / 256.0f) * Math.pow(deltaB, 2.0), 0.5));
    }

    public static Float hsbEuclidean(RColor color1, RColor color2) {
        HSBColor hsb1 = color1.toHSB();
        HSBColor hsb2 = color2.toHSB();
        float deltaH = hsb1.getHue().floatValue() - hsb2.getHue().floatValue();
        deltaH = Math.abs(deltaH) > 180.0f ? (hsb1.getHue().floatValue() < hsb2.getHue().floatValue() ? (deltaH += 360.0f) : 360.0f - deltaH) : Math.abs(deltaH);
        return Float.valueOf((float)Math.pow(Math.pow((double)deltaH / 1.8, 2.0) + Math.pow(hsb1.getSaturation().floatValue() - hsb2.getSaturation().floatValue(), 2.0) + Math.pow(hsb1.getBrightness().floatValue() - hsb2.getBrightness().floatValue(), 2.0), 0.5));
    }

    public static Float hsbCylinder(RColor color1, RColor color2) {
        HSBColor hsb1 = color1.toHSB();
        HSBColor hsb2 = color2.toHSB();
        double x1 = Math.cos(Math.PI * 2 * (double)hsb1.getHue().floatValue() / 360.0) * (double)hsb1.getSaturation().floatValue();
        double y1 = Math.sin(Math.PI * 2 * (double)hsb1.getHue().floatValue() / 360.0) * (double)hsb1.getSaturation().floatValue();
        double x2 = Math.cos(Math.PI * 2 * (double)hsb2.getHue().floatValue() / 360.0) * (double)hsb2.getSaturation().floatValue();
        double y2 = Math.sin(Math.PI * 2 * (double)hsb2.getHue().floatValue() / 360.0) * (double)hsb2.getSaturation().floatValue();
        return Float.valueOf((float)Math.pow(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(hsb1.getBrightness().floatValue() - hsb2.getBrightness().floatValue(), 2.0), 0.5));
    }

    public static Float hsbCone(RColor color1, RColor color2) {
        HSBColor hsb1 = color1.toHSB();
        HSBColor hsb2 = color2.toHSB();
        float r1 = hsb1.getSaturation().floatValue() * hsb1.getBrightness().floatValue() / 100.0f;
        float r2 = hsb2.getSaturation().floatValue() * hsb2.getBrightness().floatValue() / 100.0f;
        double x1 = Math.cos(Math.PI * 2 * (double)hsb1.getHue().floatValue() / 360.0) * (double)r1;
        double y1 = Math.sin(Math.PI * 2 * (double)hsb1.getHue().floatValue() / 360.0) * (double)r1;
        double x2 = Math.cos(Math.PI * 2 * (double)hsb2.getHue().floatValue() / 360.0) * (double)r2;
        double y2 = Math.sin(Math.PI * 2 * (double)hsb2.getHue().floatValue() / 360.0) * (double)r2;
        return Float.valueOf((float)Math.pow(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(hsb1.getBrightness().floatValue() - hsb2.getBrightness().floatValue(), 2.0), 0.5));
    }

    public static Float xyzEuclidean(RColor color1, RColor color2) {
        XYZColor xyz1 = color1.toXYZ();
        XYZColor xyz2 = color2.toXYZ();
        return Float.valueOf((float)Math.pow(Math.pow(xyz1.getX().floatValue() - xyz2.getX().floatValue(), 2.0) + Math.pow(xyz1.getY().floatValue() - xyz2.getY().floatValue(), 2.0) + Math.pow(xyz1.getZ().floatValue() - xyz2.getZ().floatValue(), 2.0), 0.5));
    }

    public static Float labDeltaC(RColor color1, RColor color2) {
        LabColor lab1 = color1.toLab();
        LabColor lab2 = color2.toLab();
        return Float.valueOf(LabColor.getChroma(lab2.getA(), lab2.getB()) - LabColor.getChroma(lab1.getA(), lab1.getB()));
    }

    public static Float labDeltaH(RColor color1, RColor color2) {
        LabColor lab1 = color1.toLab();
        LabColor lab2 = color2.toLab();
        double underRoot = Math.pow(lab2.getA().floatValue() - lab1.getA().floatValue(), 2.0) + Math.pow(lab2.getB().floatValue() - lab1.getB().floatValue(), 2.0) - Math.pow(ColorDifference.labDeltaC(lab1, lab2).floatValue(), 2.0);
        float dist = (float)Math.pow(underRoot, 0.5);
        return Float.valueOf(Float.isNaN(dist) ? 0.0f : dist);
    }

    public static Float labDeltaE(RColor color1, RColor color2) {
        LabColor lab1 = color1.toLab();
        LabColor lab2 = color2.toLab();
        return Float.valueOf((float)Math.pow(Math.pow(lab1.getLuminance() - lab2.getLuminance(), 2.0) + Math.pow(lab1.getA().floatValue() - lab2.getA().floatValue(), 2.0) + Math.pow(lab1.getB().floatValue() - lab2.getB().floatValue(), 2.0), 0.5));
    }

    public static Float labDeltaE1994(RColor color1, RColor color2) {
        LabColor lab1 = color1.toLab();
        LabColor lab2 = color2.toLab();
        float c1 = lab1.getChroma().floatValue();
        float c2 = lab2.getChroma().floatValue();
        float deltaC = c2 - c1;
        float deltaL = lab2.getLuminance() - lab1.getLuminance();
        float deltaE = ColorDifference.labDeltaE(lab1, lab2).floatValue();
        float deltaH = deltaE * deltaE - deltaL * deltaL - deltaC * deltaC;
        deltaH = deltaH > 0.0f ? (float)Math.pow(deltaH, 0.5) : 0.0f;
        float sL = 1.0f;
        float sC = 1.0f + 0.045f * c1;
        float sH = 1.0f + 0.015f * c1;
        return Float.valueOf((float)Math.pow((deltaL /= weightingLuminance * sL) * deltaL + (deltaC /= weightingChroma * sC) * deltaC + (deltaH /= weightingHue * sH) * deltaH, 0.5));
    }

    public static Float labDeltaE2000(RColor color1, RColor color2) {
        LabColor lab1 = color1.toLab();
        LabColor lab2 = color2.toLab();
        double meanChroma = 0.5 * (double)(lab1.getChroma().floatValue() + lab2.getChroma().floatValue());
        double gx = 0.5 * (1.0 - Math.pow(Math.pow(meanChroma, 7.0) / (Math.pow(meanChroma, 7.0) + Math.pow(25.0, 7.0)), 0.5));
        double a1 = (1.0 + gx) * (double)lab1.getA().floatValue();
        double a2 = (1.0 + gx) * (double)lab2.getA().floatValue();
        double c1 = LabColor.getChroma(Float.valueOf((float)a1), lab1.getB());
        double c2 = LabColor.getChroma(Float.valueOf((float)a2), lab2.getB());
        double h1 = LabColor.getHue(c1, lab1.getB().floatValue());
        double h2 = LabColor.getHue(c2, lab2.getB().floatValue());
        double deltaL = lab2.getLuminance() - lab1.getLuminance();
        double deltaC = c2 - c1;
        double deltaH = 0.0;
        if (c1 * c2 != 0.0) {
            deltaH = Math.abs(h2 - h1) <= 180.0 ? h2 - h1 : (h2 - h1 > 180.0 ? h2 - h1 - 360.0 : h2 - h1 + 360.0);
        }
        deltaH = 2.0 * Math.pow(c1 * c2, 0.5) * Math.sin(Math.PI * deltaH / 360.0);
        float meanL = 0.5f * (lab1.getLuminance() + lab2.getLuminance());
        double meanC = 0.5 * (c1 + c2);
        double meanH = h1 + h2;
        if (c1 * c2 != 0.0) {
            if (Math.abs(h1 - h2) > 180.0) {
                meanH = h2 + h1 < 360.0 ? h2 + h1 + 360.0 : h2 + h1 - 360.0;
            }
            meanH *= 0.5;
        }
        double t = 1.0 - 0.17 * Math.cos(Math.PI * 2 * (meanH - 30.0) / 360.0) + 0.24 * Math.cos(Math.PI * 4 * meanH / 360.0) + 0.32 * Math.cos(Math.PI * 2 * (3.0 * meanH + 6.0) / 360.0) - 0.2 * Math.cos(Math.PI * 2 * (4.0 * meanH - 63.0) / 360.0);
        double pH = 30.0 * Math.exp(-1.0 * (meanH - 275.0) / 25.0 * (meanH - 275.0) / 25.0);
        double rootC = 2.0 * Math.pow(Math.pow(meanC, 7.0) / (Math.pow(meanC, 7.0) + Math.pow(25.0, 7.0)), 0.5);
        double sL = 1.0 + 0.015 * (double)(meanL - 50.0f) * (double)(meanL - 50.0f) / Math.pow(20.0f + (meanL - 50.0f) * (meanL - 50.0f), 0.5);
        double sC = 1.0 + 0.045 * meanC;
        double sH = 1.0 + 0.015 * meanC * t;
        double rt = -1.0 * Math.sin(Math.PI * 4 * pH / 360.0) * rootC;
        float dist = (float)Math.pow((deltaL /= (double)weightingLuminance * sL) * deltaL + (deltaC /= (double)weightingChroma * sC) * deltaC + (deltaH /= (double)weightingHue * sH) * deltaH + rt * deltaC * deltaH, 0.5);
        return Float.valueOf(dist);
    }

    public static Float lchCMC(RColor color1, RColor color2) {
        LabColor lab1 = color1.toLab();
        LabColor lab2 = color2.toLab();
        float c1 = lab1.getChroma().floatValue();
        float c2 = lab2.getChroma().floatValue();
        double f = Math.pow(Math.pow(c1, 4.0) / (Math.pow(c1, 4.0) + 1900.0), 0.5);
        float h1 = lab1.getHue().floatValue();
        double t = 0.0;
        t = 164.0f < h1 || h1 > 345.0f ? 0.36 + Math.abs(0.4 * Math.cos(Math.PI * 2 * (double)(h1 + 35.0f) / 360.0)) : 0.56 + Math.abs(0.2 * Math.cos(Math.PI * 2 * (double)(h1 + 168.0f) / 360.0));
        double sL = 0.511;
        if (lab1.getLuminance() >= 16.0f) {
            sL = 0.040975 * (double)lab1.getLuminance() / (1.0 + 0.01765 * (double)lab1.getLuminance());
        }
        double sC = 0.638 + 0.0638 * (double)c1 / (1.0 + 0.0131 * (double)c1);
        double sH = sC * (f * t + 1.0 - f);
        Float deltaH = ColorDifference.labDeltaH(lab1, lab2);
        sL = (double)(lab2.getLuminance() - lab1.getLuminance()) / (sL * (double)weightingChroma);
        sC = (double)(c2 - c1) / (sC * (double)weightingChroma);
        sH = (double)deltaH.floatValue() / sH;
        float dist = (float)Math.pow(sL * sL + sC * sC + sH * sH, 0.5);
        return Float.valueOf(dist);
    }

    public static Float lchEuclidean(RColor color1, RColor color2) {
        LCHColor lch1 = color1.toLCH();
        LCHColor lch2 = color2.toLCH();
        float c1 = 100.0f * lch1.getChroma().floatValue() / 133.45f;
        float c2 = 100.0f * lch2.getChroma().floatValue() / 133.45f;
        double x1 = Math.cos(Math.PI * (double)lch1.getHue().floatValue() / 180.0) * (double)c1;
        double y1 = Math.sin(Math.PI * (double)lch1.getHue().floatValue() / 180.0) * (double)c1;
        double x2 = Math.cos(Math.PI * (double)lch2.getHue().floatValue() / 180.0) * (double)c2;
        double y2 = Math.sin(Math.PI * (double)lch2.getHue().floatValue() / 180.0) * (double)c2;
        float meanWeightingCH = (weightingHue + weightingChroma) * 0.5f;
        return Float.valueOf((float)Math.pow(Math.pow((x1 - x2) / (double)meanWeightingCH, 2.0) + Math.pow((y1 - y2) / (double)meanWeightingCH, 2.0) + Math.pow((lch1.getLuminance().floatValue() - lch2.getLuminance().floatValue()) / weightingLuminance, 2.0), 0.5));
    }
}

