/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.analytics;

import net.returnvoid.analytics.ClusteringHelper;
import net.returnvoid.analytics.ColorCluster;
import net.returnvoid.analytics.ColorClustering;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorHelper;
import net.returnvoid.color.ColorPalette;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.RColor;
import net.returnvoid.io.ImageUpdateObserver;
import net.returnvoid.tools.ProcessingTools;
import net.returnvoid.tools.RMath;
import net.returnvoid.tools.StringTools;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class ColorClusteringBuilder
implements ImageUpdateObserver {
    private final PApplet parent;
    private PImage inputImg;
    private RColor[] inputColors;
    private RColor[] trainingColors;
    private ColorClustering[] clusterings;
    private PImage[] quantizes;
    private int minK = 2;
    private int maxK = 30;
    private int optimalK = -1;
    private int trainingSize = 420;
    private ColorDifferenceMeasure m;

    public ColorClusteringBuilder(PApplet parent) {
        this(parent, ColorDifferenceMeasure.RGBEuclidean);
    }

    public ColorClusteringBuilder(PApplet parent, ColorDifferenceMeasure m) {
        this.m = m;
        this.parent = parent;
        this.inputImg = null;
        this.inputColors = null;
        this.clusterings = new ColorClustering[0];
        this.trainingColors = new RColor[0];
        this.quantizes = new PImage[0];
    }

    public ColorClusteringBuilder setTrainingSize(int trainingSize) {
        if (trainingSize > this.maxK) {
            this.trainingSize = trainingSize;
        }
        return this;
    }

    public ColorClusteringBuilder setMaxK(int k) {
        if (k > this.minK) {
            this.maxK = k;
            if (this.maxK >= this.trainingSize) {
                this.trainingSize = this.maxK + 1;
            }
        }
        return this;
    }

    public int size() {
        return this.clusterings.length;
    }

    public ColorClustering get(int index) {
        return this.clusterings[index];
    }

    public ColorClustering getClustering() {
        return this.getClustering(this.getOptimalK());
    }

    public ColorClustering getClustering(int k) {
        if (this.clusterings.length == 0 || k - this.minK >= this.clusterings.length) {
            return null;
        }
        return this.clusterings[k - this.minK];
    }

    public ColorDifferenceMeasure getColorDifferenceMeasure() {
        return this.m;
    }

    public PImage getInputImg() {
        return this.inputImg;
    }

    public RColor[] getColors() {
        if (this.inputColors != null) {
            return this.inputColors;
        }
        return this.getClustering(this.minK).getMembers();
    }

    public int getMaxK() {
        return this.maxK;
    }

    public int getMinK() {
        return this.minK;
    }

    public int getOptimalK() {
        if (this.clusterings.length == 0) {
            return -1;
        }
        if (this.optimalK == -1) {
            float[] losses = ClusteringHelper.getLosses(this.clusterings);
            float[] lossRang = RMath.range(losses);
            float maxLoss = lossRang[1] - lossRang[0];
            int i = 0;
            while (i < losses.length) {
                float diff = i == 0 ? maxLoss : losses[i] - losses[i - 1];
                float pDiff = 100.0f * diff / maxLoss;
                if (RMath.abs(pDiff) <= 1.0f && (pDiff < 0.0f || (double)pDiff < 0.001)) {
                    float nextnextP;
                    float nextP = i == losses.length - 1 ? 0.0f : 100.0f * (losses[i + 1] - losses[i]) / maxLoss;
                    float f = nextnextP = i >= losses.length - 2 ? 0.0f : 100.0f * (losses[i + 2] - losses[i + 1]) / maxLoss;
                    if (RMath.abs(nextP) < 2.0f && RMath.abs(nextnextP) < 2.0f && (double)(RMath.abs(nextP) + RMath.abs(nextnextP)) <= 3.0 && (nextP < 0.0f || nextP <= 1.0f) && (nextnextP < 0.0f || (double)nextnextP < 1.0)) {
                        this.optimalK = i + this.minK;
                        break;
                    }
                }
                ++i;
            }
            if (this.optimalK == -1) {
                this.optimalK = this.maxK;
            }
        }
        return this.optimalK;
    }

    @Override
    public void setImage(PImage inputImg) {
        this.inputImg = inputImg;
        this.inputColors = null;
        this.update();
    }

    public void setColors(RColor[] inputColors) {
        this.inputImg = null;
        this.inputColors = inputColors;
        this.update();
    }

    public PImage getQuantizedImage() {
        return this.getQuantizedImage(this.getOptimalK());
    }

    public PImage getQuantizedImage(int k) {
        if (this.quantizes[k - this.minK] == null) {
            return this.getQuantizedImagePreview(k);
        }
        return this.quantizes[k - this.minK];
    }

    public PImage getQuantizedImageFull() {
        return this.getQuantizedImageFull(this.getOptimalK());
    }

    public PImage getQuantizedImageFull(int k) {
        if (this.inputImg == null || this.clusterings.length == 0 || k - this.minK >= this.clusterings.length) {
            return null;
        }
        if (this.quantizes[k - this.minK] == null || this.quantizes[k - this.minK].width < this.inputImg.width) {
            PImage copy;
            this.quantizes[k - this.minK] = copy = this.inputImg.copy();
            ColorPalette palette = this.clusterings[k - this.minK].toColorPalette(false);
            palette.get(copy);
        }
        return this.quantizes[k - this.minK];
    }

    public PImage getQuantizedImagePreview() {
        return this.getQuantizedImagePreview(this.getOptimalK());
    }

    public PImage getQuantizedImagePreview(int k) {
        if (this.inputImg == null || this.clusterings.length == 0 || k - this.minK >= this.clusterings.length) {
            return null;
        }
        if (this.quantizes[k - this.minK] == null) {
            PImage copy = this.inputImg.copy();
            if (copy.width > copy.height) {
                copy.resize(600, 0);
            } else {
                copy.resize(0, 600);
            }
            this.quantizes[k - this.minK] = copy;
            ColorPalette palette = this.clusterings[k - this.minK].toColorPalette(false);
            palette.get(copy);
        }
        return this.quantizes[k - this.minK];
    }

    public void update() {
        int oldRange = this.clusterings.length;
        this.optimalK = -1;
        this.trainingColors = this.getTrainingColors();
        this.clusterings = ClusteringHelper.kmeansClusterings(this.trainingColors, this.minK, this.maxK, this.m);
        if (oldRange != this.clusterings.length) {
            this.quantizes = new PImage[this.clusterings.length];
        } else {
            int i = 0;
            while (i < this.quantizes.length) {
                this.quantizes[i] = null;
                ++i;
            }
        }
    }

    public void setColorDifferenceMeasure(ColorDifferenceMeasure m) {
        if (!this.m.equals((Object)m)) {
            ColorSpace oldSpace = this.m.toColorSpace();
            ColorSpace newSpace = m.toColorSpace();
            this.optimalK = -1;
            this.m = m;
            if (!oldSpace.equals((Object)newSpace)) {
                RColor[] rColorArray = this.trainingColors;
                int n = this.trainingColors.length;
                int n2 = 0;
                while (n2 < n) {
                    RColor c = rColorArray[n2];
                    c = ColorHelper.convert(c, newSpace);
                    ++n2;
                }
            }
            int i = 0;
            while (i < this.quantizes.length) {
                this.quantizes[i] = null;
                ++i;
            }
            this.clusterings = ClusteringHelper.kmeansClusterings(this.trainingColors, this.minK, this.maxK, m);
        }
    }

    private RColor[] getTrainingColors() {
        if (this.inputImg == null && this.inputColors == null) {
            System.err.println("You can't create any clusters without data. Please call setImage(PImage) or setColors(RColor[]) before trying to cluster.");
            return null;
        }
        if (this.inputImg != null) {
            return ClusteringHelper.getTrainingColors(this.inputImg, (Integer)this.trainingSize, this.m, (Integer)1);
        }
        if (this.inputColors[0].getColorSpace() == this.m.toColorSpace() && this.inputColors.length <= this.trainingSize) {
            return this.inputColors;
        }
        return ClusteringHelper.getTrainingColors(this.inputColors, (Integer)this.trainingSize, this.m);
    }

    public void export(int k, String fileName) {
        if (this.clusterings.length == 0) {
            System.err.println("no clustering done yet");
            return;
        }
        String path = String.valueOf(ProcessingTools.getSketchPath(this.parent)) + "/export/";
        String time = StringTools.timestamp();
        String fileAndMeasure = String.valueOf(fileName) + "_" + this.m.name();
        System.out.println("exporting 1 / 6");
        if (this.inputImg != null) {
            PImage img;
            if (this.quantizes[k - this.minK] != null && this.quantizes[k - this.minK].width == this.inputImg.width) {
                img = this.quantizes[k - this.minK];
            } else {
                ColorPalette palette = this.clusterings[k - this.minK].toColorPalette(false);
                this.quantizes[k - this.minK] = img = this.inputImg.copy();
                String stamp = palette.get(img);
                while (!palette.finishedImage(stamp)) {
                }
            }
            img.save(String.valueOf(path) + fileAndMeasure + "_" + time + "_quantization_k" + k + ".png");
        }
        System.out.println("exporting 2 / 6");
        this.parent.g.beginDraw();
        this.parent.g.background(247);
        this.drawLoss(this.parent.g, 0.0f, 0.0f, this.parent.width, this.parent.height, -1);
        this.parent.g.endDraw();
        this.parent.g.save(String.valueOf(path) + fileAndMeasure + "_" + time + "_loss.png");
        System.out.println("exporting 3 / 6");
        this.parent.g.beginDraw();
        this.parent.g.background(247);
        this.drawClustering(this.parent.g, 0.0f, 0.0f, this.parent.width, this.parent.height, k);
        this.parent.g.endDraw();
        this.parent.g.save(String.valueOf(path) + fileAndMeasure + "_" + time + "_clustering_k" + k + ".png");
        System.out.println("exporting 4 / 6");
        if (this.inputImg != null) {
            this.parent.g.beginDraw();
            this.parent.g.background(247);
            this.drawImageWithClustering(this.parent.g, 0.0f, 0.0f, this.parent.width, this.parent.height, k);
            this.parent.g.endDraw();
            this.parent.g.save(String.valueOf(path) + fileAndMeasure + "_" + time + "_imgAndClustering_k" + k + ".png");
        }
        System.out.println("exporting 5 / 6");
        this.parent.g.beginDraw();
        this.parent.g.background(247);
        this.drawAllClusteringsMeans(this.parent.g, 0.0f, 0.0f, this.parent.width, this.parent.height);
        this.parent.g.endDraw();
        this.parent.g.save(String.valueOf(path) + fileAndMeasure + "_" + time + "_clustering_all.png");
        System.out.println("exporting 6 / 6");
        this.parent.g.beginDraw();
        this.parent.g.background(247);
        this.drawInputColors(this.parent.g, 0.0f, 0.0f, this.parent.width, this.parent.height);
        this.parent.g.endDraw();
        this.parent.g.save(String.valueOf(path) + fileAndMeasure + "_" + time + "_inputcolors.png");
        System.out.println("done exporting");
    }

    public void drawQuantizedImage(float x, float y, float w, float h, int k) {
        this.drawQuantizedImage(null, x, y, w, h, k);
    }

    public void drawQuantizedImage(PGraphics g, float x, float y, float w, float h, int k) {
        if (this.inputImg == null || this.clusterings.length == 0) {
            return;
        }
        float amtW = w / (float)this.inputImg.width;
        float amtH = h / (float)this.inputImg.height;
        float amt = RMath.max(amtW, amtH);
        float iW = (float)this.inputImg.width * amt;
        float iH = (float)this.inputImg.height * amt;
        float iX = x - RMath.abs(iW - w) * 0.5f;
        float iY = y - RMath.abs(iH - h) * 0.5f;
        if (g == null) {
            this.parent.image(this.getQuantizedImage(k), iX, iY, iW, iH);
        } else {
            g.image(this.getQuantizedImage(k), iX, iY, iW, iH);
        }
    }

    public void drawImage(float x, float y, float w, float h) {
        this.drawImage(null, x, y, w, h);
    }

    public void drawImage(PGraphics g, float x, float y, float w, float h) {
        if (this.inputImg == null) {
            return;
        }
        float amtW = w / (float)this.inputImg.width;
        float amtH = h / (float)this.inputImg.height;
        float amt = RMath.max(amtW, amtH);
        float iW = (float)this.inputImg.width * amt;
        float iH = (float)this.inputImg.height * amt;
        float iX = x - RMath.abs(iW - w) * 0.5f;
        float iY = y - RMath.abs(iH - h) * 0.5f;
        if (g == null) {
            this.parent.image(this.inputImg, iX, iY, iW, iH);
        } else {
            g.image(this.inputImg, iX, iY, iW, iH);
        }
    }

    public void drawLoss(float x, float y, float w, float h) {
        this.drawLoss(null, x, y, w, h, -1);
    }

    public void drawLoss(float x, float y, float w, float h, int highlight) {
        this.drawLoss(null, x, y, w, h, highlight);
    }

    public void drawLoss(PGraphics g, float x, float y, float w, float h, int highlight) {
        float cy;
        float ch;
        float cx;
        if (this.clusterings.length < 1 + this.maxK - this.minK) {
            return;
        }
        if (g == null) {
            this.parent.fill(227);
            this.parent.noStroke();
            this.parent.rect(x, y, w, h);
        } else {
            g.fill(227);
            g.noStroke();
            g.rect(x, y, w, h);
        }
        float cw = w / (float)this.clusterings.length;
        float fontSize = cw * 0.3f;
        float textPadd = cw * 0.5f;
        if (g == null) {
            this.parent.textSize(fontSize);
            this.parent.textAlign(3, 3);
        } else {
            g.textSize(fontSize);
            g.textAlign(3, 3);
        }
        int i = 0;
        while (i < this.clusterings.length) {
            float cx2 = x + cw * (float)i;
            if (i + this.minK == highlight) {
                if (g == null) {
                    this.parent.fill(20.0f, 80.0f, 100.0f, 80.0f);
                    this.parent.rect(cx2 - 0.5f, y, cw + 1.0f, h - textPadd);
                } else {
                    g.fill(200);
                    g.rect(cx2 - 0.5f, y, cw + 1.0f, h - textPadd);
                }
            } else if (i % 2 == 0) {
                if (g == null) {
                    this.parent.fill(200);
                    this.parent.rect(cx2 - 0.5f, y, cw + 1.0f, h - textPadd);
                } else {
                    g.fill(200);
                    g.rect(cx2 - 0.5f, y, cw + 1.0f, h - textPadd);
                }
            }
            if (g == null) {
                this.parent.fill(20);
                this.parent.text("k=" + this.clusterings[i].getK(), cx2 - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            } else {
                g.fill(20);
                g.text("k=" + this.clusterings[i].getK(), cx2 - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            }
            ++i;
        }
        float[] losses = ClusteringHelper.getLosses(this.clusterings);
        float minLoss = RMath.min(losses);
        float maxLoss = RMath.max(losses) - minLoss;
        float lossScale = 1.1f;
        if (g == null) {
            this.parent.textAlign(3, 102);
        } else {
            g.textAlign(3, 102);
        }
        int i2 = 0;
        while (i2 < losses.length) {
            cx = x + cw * (float)i2;
            ch = PApplet.map((float)losses[i2], (float)0.0f, (float)((minLoss + maxLoss) * lossScale), (float)0.0f, (float)(h - textPadd));
            cy = y + h - textPadd - ch;
            if (this.getOptimalK() == i2 + this.minK) {
                if (g == null) {
                    this.parent.fill(20.0f, 80.0f, 100.0f);
                } else {
                    g.fill(20.0f, 80.0f, 100.0f);
                }
            } else if (g == null) {
                this.parent.fill(50);
            } else {
                g.fill(50);
            }
            if (g == null) {
                this.parent.noStroke();
                this.parent.rect(cx + 1.5f, cy, cw - 3.0f, ch);
                this.parent.text(StringTools.nfs(losses[i2], 2, 2), cx + cw * 0.5f, cy - textPadd * 0.1f);
            } else {
                g.noStroke();
                g.rect(cx + 1.5f, cy, cw - 3.0f, ch);
                g.text(StringTools.nfs(losses[i2], 2, 2), cx + cw * 0.5f, cy - textPadd * 0.1f);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < losses.length) {
            float diff;
            cx = x + cw * (float)i2;
            ch = PApplet.map((float)losses[i2], (float)0.0f, (float)((minLoss + maxLoss) * lossScale), (float)0.0f, (float)(h - textPadd));
            cy = y + h - textPadd - ch;
            float f = diff = i2 == 0 ? 0.0f : losses[i2] - losses[i2 - 1];
            if (g == null) {
                this.parent.fill(247);
                this.parent.text(StringTools.nfs(diff, 2, 2), cx + cw * 0.5f, cy + textPadd);
            } else {
                g.fill(247);
                g.text(StringTools.nfs(diff, 2, 2), cx + cw * 0.5f, cy + textPadd);
            }
            if (this.getOptimalK() == i2 + this.minK) {
                if (g == null) {
                    this.parent.fill(180);
                } else {
                    g.fill(180);
                }
            } else if (g == null) {
                this.parent.fill(230.0f, 15.0f, 120.0f);
            } else {
                g.fill(230.0f, 15.0f, 120.0f);
            }
            if (g == null) {
                this.parent.text(String.valueOf(StringTools.nfs(100.0f * diff / maxLoss, 2, 2)) + "%", cx + cw * 0.5f, cy + 2.0f * textPadd);
            } else {
                g.text(String.valueOf(StringTools.nfs(100.0f * diff / maxLoss, 2, 2)) + "%", cx + cw * 0.5f, cy + 2.0f * textPadd);
            }
            ++i2;
        }
    }

    public void drawClustering(float x, float y, float w, float h, int k) {
        this.drawClustering(null, x, y, w, h, k);
    }

    public void drawClustering(PGraphics g, float x, float y, float w, float h, int k) {
        if (this.clusterings.length < 1 + this.maxK - this.minK) {
            return;
        }
        ColorCluster[] clusters = this.clusterings[k - this.minK].getClusters();
        k = clusters.length;
        float cH = h / (float)k;
        if (g == null) {
            this.parent.noStroke();
        } else {
            g.noStroke();
        }
        int i = 0;
        while (i < clusters.length) {
            float cY = y + (float)i * cH;
            if (g == null) {
                this.parent.fill(clusters[i].getMean().getColor());
                this.parent.rect(x, cY - 0.5f, w, cH + 1.0f);
            } else {
                g.fill(clusters[i].getMean().getColor());
                g.rect(x, cY - 0.5f, w, cH + 1.0f);
            }
            ++i;
        }
    }

    public void drawImageWithClustering(float x, float y, float w, float h, int k) {
        this.drawImageWithClustering(null, x, y, w, h, k);
    }

    public void drawImageWithClustering(PGraphics g, float x, float y, float w, float h, int k) {
        if (this.inputImg == null) {
            return;
        }
        float amtW = w / (float)this.inputImg.width;
        float amtH = h / (float)this.inputImg.height;
        float amt = RMath.max(amtW, amtH);
        float iW = (float)this.inputImg.width * amt;
        float iH = (float)this.inputImg.height * amt;
        float iX = x - RMath.abs(iW - w) * 0.5f;
        float iY = y - RMath.abs(iH - h) * 0.5f;
        if (g == null) {
            this.parent.image(this.inputImg, iX, iY, iW, iH);
        } else {
            g.image(this.inputImg, iX, iY, iW, iH);
        }
        ColorCluster[] clusters = this.clusterings[k - this.minK].getClusters();
        k = clusters.length;
        float rPaddY = h * 0.1f + 0.2f * h / (float)k;
        float rH = (h - 2.0f * rPaddY) / (float)(2 * k - 1);
        float rW = w / 2.0f;
        float rX = x + 0.5f * (w - rW);
        if (g == null) {
            this.parent.noStroke();
        } else {
            g.noStroke();
        }
        int i = 0;
        while (i < clusters.length) {
            float rY = y + rPaddY + (float)(2 * i) * rH;
            if (g == null) {
                this.parent.fill(clusters[i].getMean().getColor());
                this.parent.rect(rX, rY, rW, rH);
            } else {
                g.fill(clusters[i].getMean().getColor());
                g.rect(rX, rY, rW, rH);
            }
            ++i;
        }
    }

    public void drawAllClusteringsMeans(float x, float y, float w, float h) {
        this.drawAllClusteringsMeans(null, x, y, w, h);
    }

    public void drawAllClusteringsMeans(PGraphics g, float x, float y, float w, float h) {
        if (this.clusterings.length < 1 + this.maxK - this.minK) {
            return;
        }
        float cw = w / (float)this.clusterings.length;
        float fontSize = cw * 0.3f;
        float textPadd = cw * 0.5f;
        if (g == null) {
            this.parent.textSize(fontSize);
            this.parent.textAlign(3, 3);
        } else {
            g.textSize(fontSize);
            g.textAlign(3, 3);
        }
        int i = 0;
        while (i < this.clusterings.length) {
            float cx = x + cw * (float)i;
            float cy = y;
            float ch = h - textPadd;
            if (g == null) {
                this.clusterings[i].drawMeans(this.parent, cx - 0.5f, cy - 0.5f, cw + 1.0f, ch + 1.0f);
            } else {
                this.clusterings[i].drawMeans(g, cx - 0.5f, cy - 0.5f, cw + 1.0f, ch + 1.0f);
            }
            if (g == null) {
                this.parent.fill(20);
                this.parent.text("k=" + this.clusterings[i].getK(), cx - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            } else {
                g.fill(20);
                g.text("k=" + this.clusterings[i].getK(), cx - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            }
            ++i;
        }
    }

    public void drawAllClusterings(float x, float y, float w, float h) {
        this.drawAllClusterings(null, x, y, w, h);
    }

    public void drawAllClusterings(PGraphics g, float x, float y, float w, float h) {
        if (this.clusterings.length < 1 + this.maxK - this.minK) {
            return;
        }
        float cw = w / (float)this.clusterings.length;
        float fontSize = cw * 0.3f;
        float textPadd = cw * 0.5f;
        if (g == null) {
            this.parent.textSize(fontSize);
            this.parent.textAlign(3, 3);
        } else {
            g.textSize(fontSize);
            g.textAlign(3, 3);
        }
        int i = 0;
        while (i < this.clusterings.length) {
            float cx = x + cw * (float)i;
            float cy = y;
            float ch = h - textPadd;
            if (g == null) {
                this.clusterings[i].drawMeans(this.parent, cx - 0.5f, cy - 0.5f, cw + 1.0f, ch + 1.0f);
                this.clusterings[i].drawMembers(this.parent, cx - 0.5f + cw * 0.5f, cy - 0.5f, (cw + 1.0f) * 0.5f, ch + 1.0f);
            } else {
                this.clusterings[i].drawMeans(g, cx - 0.5f, cy - 0.5f, cw + 1.0f, ch + 1.0f);
                this.clusterings[i].drawMembers(g, cx - 0.5f + cw * 0.5f, cy - 0.5f, (cw + 1.0f) * 0.5f, ch + 1.0f);
            }
            if (g == null) {
                this.parent.fill(20);
                this.parent.text("k=" + this.clusterings[i].getK(), cx - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            } else {
                g.fill(20);
                g.text("k=" + this.clusterings[i].getK(), cx - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            }
            ++i;
        }
    }

    public void drawAllClusteringsMembers(float x, float y, float w, float h) {
        this.drawAllClusteringsMembers(null, x, y, w, h);
    }

    public void drawAllClusteringsMembers(PGraphics g, float x, float y, float w, float h) {
        if (this.clusterings.length < 1 + this.maxK - this.minK) {
            return;
        }
        float cw = w / (float)this.clusterings.length;
        float fontSize = cw * 0.3f;
        float textPadd = cw * 0.5f;
        if (g == null) {
            this.parent.textSize(fontSize);
            this.parent.textAlign(3, 3);
        } else {
            g.textSize(fontSize);
            g.textAlign(3, 3);
        }
        int i = 0;
        while (i < this.clusterings.length) {
            float cx = x + cw * (float)i;
            float cy = y;
            float ch = h - textPadd;
            if (g == null) {
                this.clusterings[i].drawMembers(this.parent, cx - 0.5f, cy - 0.5f, cw + 1.0f, ch + 1.0f);
            } else {
                this.clusterings[i].drawMembers(g, cx - 0.5f, cy - 0.5f, cw + 1.0f, ch + 1.0f);
            }
            if (g == null) {
                this.parent.fill(20);
                this.parent.text("k=" + this.clusterings[i].getK(), cx - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            } else {
                g.fill(20);
                g.text("k=" + this.clusterings[i].getK(), cx - 0.5f + cw * 0.5f, y + h - textPadd * 0.5f);
            }
            ++i;
        }
    }

    public void drawInputColors(float x, float y, float w, float h) {
        this.drawInputColors(null, x, y, w, h);
    }

    public void drawInputColors(PGraphics g, float x, float y, float w, float h) {
        if (this.clusterings.length < 1 + this.maxK - this.minK) {
            return;
        }
        float cw = w / (float)this.trainingColors.length;
        int i = 0;
        while (i < this.trainingColors.length) {
            float cx = x + cw * (float)i;
            float cy = y;
            float ch = h;
            if (g == null) {
                this.parent.noStroke();
                this.parent.fill(this.trainingColors[i].getColor());
                this.parent.rect(cx - 0.5f, cy, cw + 1.0f, ch);
            } else {
                g.noStroke();
                g.fill(this.trainingColors[i].getColor());
                g.rect(cx - 0.5f, cy, cw + 1.0f, ch);
            }
            ++i;
        }
    }
}

