/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.analytics;

import java.util.ArrayList;
import net.returnvoid.analytics.Clustering;
import net.returnvoid.analytics.ClusteringHelper;
import net.returnvoid.analytics.ColorCluster;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorPalette;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import processing.core.PApplet;
import processing.core.PGraphics;

public class ColorClustering
implements Clustering {
    private int k;
    private Float loss;
    private ColorCluster[] clusters;
    private RColor[] means;
    private ColorDifferenceMeasure m;

    public ColorClustering(ColorCluster[] clusters, int k) {
        this.k = k;
        this.m = clusters[0].getColorDifferenceMeasure();
        this.clusters = clusters;
        this.loss = ClusteringHelper.computeLoss(this.clusters);
        this.sort();
        this.means = this.computeMeanColors();
    }

    @Override
    public Float getLoss() {
        return this.loss;
    }

    @Override
    public int getK() {
        return this.k;
    }

    public Float getMinLuminance() {
        return this.clusters[0].getMean().toLCH().getLuminance();
    }

    public Float getMaxLuminance() {
        return this.clusters[this.clusters.length - 1].getMean().toLCH().getLuminance();
    }

    public ColorPalette toColorPalette() {
        return this.toColorPalette(false);
    }

    public ColorPalette toColorPalette(boolean useMeans) {
        int i;
        RColor[] colors;
        if (useMeans) {
            colors = this.means;
        } else {
            colors = new RColor[this.clusters.length];
            i = 0;
            while (i < colors.length) {
                colors[i] = this.clusters[i].getRepresentative().copy();
                ++i;
            }
        }
        ColorPalette cp = new ColorPalette(colors);
        cp.setColorDifferenceMeasure(this.m);
        i = 0;
        while (i < this.clusters.length) {
            cp.applyImportance(colors[i], this.clusters[i].size());
            ++i;
        }
        return cp;
    }

    public RColor[] getMeans() {
        return this.means;
    }

    public RColor[] getMembers() {
        ArrayList<RColor> colors = new ArrayList<RColor>();
        ColorCluster[] colorClusterArray = this.clusters;
        int n = this.clusters.length;
        int n2 = 0;
        while (n2 < n) {
            ColorCluster cluster = colorClusterArray[n2];
            colors.addAll(cluster.getElements());
            ++n2;
        }
        return colors.toArray(new RColor[colors.size()]);
    }

    private RColor[] computeMeanColors() {
        RColor[] means = new RColor[this.clusters.length];
        int i = 0;
        while (i < means.length) {
            means[i] = this.clusters[i].getMean();
            ++i;
        }
        return means;
    }

    public int size() {
        return this.clusters.length;
    }

    public ColorCluster get(int index) {
        return this.clusters[index];
    }

    public int getClusterIndex(Object c) {
        return -1;
    }

    public int getClusterIndex(int c) {
        return this.getClusterIndex(RGBColor.toRGB(c));
    }

    public int getClusterIndex(RColor c) {
        return ColorDifference.getMostSimilarColor(c, this.means, this.m);
    }

    @Override
    public ColorCluster getCluster(Object c) {
        return this.getCluster(Integer.parseInt("" + c));
    }

    public ColorCluster getCluster(int c) {
        return this.getCluster(RGBColor.toRGB(c));
    }

    public ColorCluster getCluster(RColor c) {
        Integer id = ColorDifference.getMostSimilarColor(c, this.means, this.m);
        if (id >= 0) {
            return this.clusters[id];
        }
        System.err.println("No cluster found for " + c);
        return null;
    }

    private void sort() {
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            int i = 0;
            while (i < this.clusters.length - 1) {
                if (this.clusters[i].getMean().toLab().getLuminance() < this.clusters[i + 1].getMean().toLab().getLuminance()) {
                    ColorCluster tmp = this.clusters[i];
                    this.clusters[i] = this.clusters[i + 1];
                    this.clusters[i + 1] = tmp;
                    sorted = false;
                }
                ++i;
            }
        }
    }

    public ColorDifferenceMeasure getColorDifferenceMeasure() {
        return this.m;
    }

    public ColorCluster[] getClusters() {
        return this.clusters;
    }

    public void drawMembers(PGraphics g, float x, float y, float w, float h) {
        this.drawMembers(g, null, x, y, w, h);
    }

    public void drawMembers(PApplet parent, float x, float y, float w, float h) {
        this.drawMembers(null, parent, x, y, w, h);
    }

    private void drawMembers(PGraphics g, PApplet parent, float x, float y, float w, float h) {
        float ch = h / (float)this.clusters.length;
        int i = 0;
        while (i < this.clusters.length) {
            float cx = x;
            float cy = y + (float)i * ch;
            float cw = w;
            if (g == null) {
                this.clusters[i].drawMembers(parent, cx, cy, cw, ch);
            } else {
                this.clusters[i].drawMembers(g, cx, cy, cw, ch);
            }
            ++i;
        }
    }

    public void drawMeans(PGraphics g, float x, float y, float w, float h) {
        this.drawMeans(g, null, x, y, w, h);
    }

    public void drawMeans(PApplet parent, float x, float y, float w, float h) {
        this.drawMeans(null, parent, x, y, w, h);
    }

    private void drawMeans(PGraphics g, PApplet parent, float x, float y, float w, float h) {
        float ch = h / (float)this.clusters.length;
        int i = 0;
        while (i < this.clusters.length) {
            float cx = x;
            float cy = y + (float)i * ch;
            float cw = w;
            if (g == null) {
                this.clusters[i].drawMean(parent, cx, cy, cw, ch);
            } else {
                this.clusters[i].drawMean(g, cx, cy, cw, ch);
            }
            ++i;
        }
    }
}

