/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.analytics;

import java.util.ArrayList;
import net.returnvoid.analytics.Cluster;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorHelper;
import net.returnvoid.color.RColor;
import processing.core.PApplet;
import processing.core.PGraphics;

public class ColorCluster
implements Cluster {
    private RColor mean;
    private ArrayList<RColor> clusterMembers;
    private ColorDifferenceMeasure m;
    private Float loss = Float.valueOf(-1.0f);

    public ColorCluster(RColor mean) {
        this(mean, ColorDifferenceMeasure.RGBEuclidean);
    }

    public ColorCluster(RColor mean, ColorDifferenceMeasure m) {
        this.m = m;
        this.mean = ColorHelper.convert(mean, m);
        this.clusterMembers = new ArrayList();
    }

    public ColorDifferenceMeasure getColorDifferenceMeasure() {
        return this.m;
    }

    public ColorCluster setColorDifferenceMeasure(ColorDifferenceMeasure m) {
        this.m = m;
        ColorHelper.convert(this.clusterMembers, m.toColorSpace());
        this.mean = ColorHelper.convert(this.mean, m);
        return this;
    }

    public int size() {
        return this.clusterMembers.size();
    }

    @Override
    public Cluster addElement(Object newMember) {
        return this;
    }

    public ColorCluster addElement(RColor newMember) {
        this.loss = null;
        this.clusterMembers.add(newMember);
        return this;
    }

    @Override
    public Cluster removeElement(Object member) {
        return this;
    }

    public ColorCluster removeElement(RColor member) {
        this.loss = null;
        this.clusterMembers.remove(member);
        return this;
    }

    @Override
    public boolean switchElement(Object member, Cluster newCluster) {
        return false;
    }

    public boolean switchElement(RColor member, ColorCluster newCluster) {
        if (newCluster == this) {
            return false;
        }
        this.removeElement(member);
        newCluster.addElement(member);
        return true;
    }

    @Override
    public ColorCluster updateMean() {
        this.loss = null;
        if (this.clusterMembers.size() > 0) {
            this.mean = this.clusterMembers.size() == 1 ? this.clusterMembers.get(0).copy() : ColorHelper.getMeanColor(this.clusterMembers, this.m);
        }
        return this;
    }

    public RColor getRepresentative() {
        int bestMeanID = ColorDifference.getMostSimilarColor(this.mean, this.clusterMembers, this.m);
        return this.clusterMembers.get(bestMeanID);
    }

    @Override
    public RColor getMean() {
        return this.mean;
    }

    public ArrayList<RColor> getElements() {
        return this.clusterMembers;
    }

    @Override
    public Float getLoss() {
        if (this.clusterMembers.size() == 0) {
            return Float.valueOf(0.0f);
        }
        if (this.loss == null) {
            this.loss = ColorHelper.getLoss(this.mean, this.clusterMembers, this.m);
        }
        return this.loss;
    }

    public void drawMean(PGraphics g, float x, float y, float w, float h) {
        this.drawMean(g, null, x, y, w, h);
    }

    public void drawMean(PApplet parent, float x, float y, float w, float h) {
        this.drawMean(null, parent, x, y, w, h);
    }

    private void drawMean(PGraphics g, PApplet parent, float x, float y, float w, float h) {
        if (g == null) {
            parent.noStroke();
            parent.fill(this.mean.getColor());
            parent.rect(x, y, w, h);
        } else {
            g.noStroke();
            g.fill(this.mean.getColor());
            g.rect(x, y, w, h);
        }
    }

    public void drawMembers(PApplet parent, float x, float y, float w, float h) {
        this.drawMembers(null, parent, x, y, w, h);
    }

    public void drawMembers(PGraphics g, float x, float y, float w, float h) {
        this.drawMembers(g, null, x, y, w, h);
    }

    private void drawMembers(PGraphics g, PApplet parent, float x, float y, float w, float h) {
        if (g == null) {
            parent.noStroke();
        } else {
            g.noStroke();
        }
        int i = 0;
        while (i < this.clusterMembers.size()) {
            float rh = h / (float)this.clusterMembers.size();
            float ry = y + (float)i * rh;
            if (g == null) {
                parent.fill(this.clusterMembers.get(i).getColor());
                parent.rect(x, ry, w, rh);
            } else {
                g.fill(this.clusterMembers.get(i).getColor());
                g.rect(x, ry, w, rh);
            }
            ++i;
        }
        if (this.clusterMembers.size() == 0) {
            if (g == null) {
                parent.strokeWeight(1.0f);
                parent.stroke(255.0f, 0.0f, 0.0f);
                parent.noFill();
                parent.rect(x, y, w, h);
                parent.noStroke();
            } else {
                g.strokeWeight(1.0f);
                g.stroke(255.0f, 0.0f, 0.0f);
                g.noFill();
                g.rect(x, y, w, h);
                g.noStroke();
            }
        }
    }
}

