/*
 * Decompiled with CFR 0.152.
 */
package net.returnvoid.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import net.returnvoid.analytics.Cluster;
import net.returnvoid.analytics.Clustering;
import net.returnvoid.analytics.ColorCluster;
import net.returnvoid.analytics.ColorClustering;
import net.returnvoid.color.ColorDifference;
import net.returnvoid.color.ColorDifferenceMeasure;
import net.returnvoid.color.ColorHelper;
import net.returnvoid.color.ColorSpace;
import net.returnvoid.color.RColor;
import net.returnvoid.color.RGBColor;
import net.returnvoid.graphics.grid.GridMaker;
import net.returnvoid.graphics.grid.TableGrid;
import net.returnvoid.tools.RMath;
import processing.core.PImage;

public class ClusteringHelper {
    private ClusteringHelper() {
    }

    public static Float computeLoss(Cluster[] clusters) {
        float loss = 0.0f;
        Cluster[] clusterArray = clusters;
        int n = clusters.length;
        int n2 = 0;
        while (n2 < n) {
            Cluster c = clusterArray[n2];
            loss += c.getLoss().floatValue();
            ++n2;
        }
        return Float.valueOf(loss /= (float)clusters.length);
    }

    public static float[] getLosses(Clustering[] clustering) {
        float[] losses = new float[clustering.length];
        int i = 0;
        while (i < losses.length) {
            losses[i] = clustering[i].getLoss().floatValue();
            ++i;
        }
        return losses;
    }

    public static Object[] getTrainingData(Object[] raw, Integer trainingSize) {
        if (raw.length <= trainingSize) {
            trainingSize = raw.length;
        }
        Object[] copyArray = new Object[raw.length];
        System.arraycopy(raw, 0, copyArray, 0, raw.length);
        int i = 0;
        while (i < copyArray.length) {
            int switchIndex = RMath.random(copyArray.length);
            Object tmp = copyArray[i];
            copyArray[i] = copyArray[switchIndex];
            copyArray[switchIndex] = tmp;
            ++i;
        }
        if (copyArray.length == trainingSize) {
            return copyArray;
        }
        Object[] shuffled = new Object[trainingSize.intValue()];
        System.arraycopy(copyArray, 0, shuffled, 0, shuffled.length);
        return shuffled;
    }

    public static ColorCluster[] colorsToClusters(RColor[] means, ColorDifferenceMeasure m) {
        ColorCluster[] clusters = new ColorCluster[means.length];
        int i = 0;
        while (i < clusters.length) {
            clusters[i] = new ColorCluster(means[i], m);
            ++i;
        }
        return clusters;
    }

    public static ColorCluster[] addColorsToClusters(ColorCluster[] clusters, RColor[] colors) {
        ColorDifferenceMeasure m = clusters[0].getColorDifferenceMeasure();
        int j = 0;
        while (j < colors.length) {
            Float minDiff = Float.valueOf(1000000.0f);
            int minID = 0;
            int i = 0;
            while (i < clusters.length) {
                Float diff = ColorDifference.difference(colors[j], clusters[i].getMean(), m);
                if (diff.floatValue() < minDiff.floatValue()) {
                    minDiff = diff;
                    minID = i;
                }
                ++i;
            }
            clusters[minID].addElement(colors[j]);
            ++j;
        }
        ColorCluster[] colorClusterArray = clusters;
        int n = clusters.length;
        int n2 = 0;
        while (n2 < n) {
            ColorCluster cluster = colorClusterArray[n2];
            cluster.updateMean();
            ++n2;
        }
        return clusters;
    }

    private static RColor[] kmeansInitialClusterMeans(RColor[] colors, Integer k, ColorCluster[] existingClusters, ColorDifferenceMeasure m) {
        if (existingClusters == null) {
            RColor[] tmpCenters = new RColor[2];
            Float maxDiff = Float.valueOf(0.0f);
            int i = 0;
            while (i < 15) {
                RColor c1 = colors[RMath.random(colors.length)];
                RColor c2 = null;
                int id = ColorDifference.getMostDifferentColor(c1, colors, m);
                c2 = id == -1 ? RGBColor.getRandomRGB() : colors[id];
                Float diff = ColorDifference.difference(c1, c2, m);
                if (diff.floatValue() > maxDiff.floatValue()) {
                    tmpCenters[0] = c1;
                    tmpCenters[1] = c2;
                }
                ++i;
            }
            if (k == 2) {
                return tmpCenters;
            }
            existingClusters = ClusteringHelper.colorsToClusters(tmpCenters, m);
        }
        RColor[] clusterCenters = new RColor[k.intValue()];
        int numberOfOldClusters = existingClusters.length;
        if (numberOfOldClusters >= k) {
            --numberOfOldClusters;
        }
        int i = 0;
        while (i < numberOfOldClusters) {
            clusterCenters[i] = existingClusters[i].getMean();
            ++i;
        }
        i = numberOfOldClusters;
        while (i < clusterCenters.length) {
            Integer id = ColorDifference.getMostDifferentColor(clusterCenters, colors, m);
            clusterCenters[i] = id == -1 ? RGBColor.getRandomRGB() : colors[id];
            ++i;
        }
        return clusterCenters;
    }

    private static ColorCluster[] kmeansClusterColors(ColorCluster[] clusters) {
        ColorDifferenceMeasure m = clusters[0].getColorDifferenceMeasure();
        boolean colorChangedCluster = true;
        int count = 0;
        while (colorChangedCluster && count < 15) {
            int k;
            colorChangedCluster = false;
            int j = 0;
            while (j < clusters.length) {
                k = 0;
                while (k < clusters[j].getElements().size()) {
                    Float minDiff = Float.valueOf(1000000.0f);
                    int minID = 0;
                    RColor c = clusters[j].getElements().get(k);
                    int i = 0;
                    while (i < clusters.length) {
                        Float diff = ColorDifference.difference(c, clusters[i].getMean(), m);
                        if (diff.floatValue() < minDiff.floatValue()) {
                            minDiff = diff;
                            minID = i;
                        }
                        ++i;
                    }
                    boolean changed = clusters[j].switchElement(c, clusters[minID]);
                    if (changed) {
                        colorChangedCluster = true;
                    }
                    ++k;
                }
                ++j;
            }
            ColorCluster[] colorClusterArray = clusters;
            int c = clusters.length;
            k = 0;
            while (k < c) {
                ColorCluster cluster = colorClusterArray[k];
                cluster.updateMean();
                ++k;
            }
            ++count;
        }
        ArrayList<ColorCluster> noEmpties = new ArrayList<ColorCluster>();
        int numberOfRemovedClusters = 0;
        int i = 0;
        while (i < clusters.length) {
            if (clusters[i].size() == 0) {
                ++numberOfRemovedClusters;
            } else {
                noEmpties.add(clusters[i]);
            }
            ++i;
        }
        if (numberOfRemovedClusters == 0) {
            return clusters;
        }
        return noEmpties.toArray(new ColorCluster[noEmpties.size()]);
    }

    public static ColorClustering kmeans(RColor[] colors, Integer k, ColorDifferenceMeasure m) {
        return ClusteringHelper.kmeans(colors, k, m, null);
    }

    public static ColorClustering kmeans(RColor[] colors, Integer k, ColorDifferenceMeasure m, ColorCluster[] existingClusters) {
        RColor[] means = ClusteringHelper.kmeansInitialClusterMeans(colors, k, existingClusters, m);
        ColorCluster[] clusters = ClusteringHelper.colorsToClusters(means, m);
        clusters = ClusteringHelper.addColorsToClusters(clusters, colors);
        clusters = ClusteringHelper.kmeansClusterColors(clusters);
        return new ColorClustering(clusters, k);
    }

    public static ColorClustering[] kmeansClusterings(RColor[] colors, Integer minK, Integer maxK, ColorDifferenceMeasure m) {
        ColorClustering[] clusterings = new ColorClustering[1 + maxK - minK];
        if (m == null) {
            m = colors[0].getColorSpace().toColorDifferenceMeasure();
        }
        int i = 0;
        while (i < clusterings.length) {
            int k = i + minK;
            clusterings[i] = ClusteringHelper.kmeans(colors, k, m, i == 0 ? null : clusterings[i - 1].getClusters());
            ++i;
        }
        return clusterings;
    }

    public static RColor[] getTrainingColors(PImage img, Integer trainingsSize) {
        return ClusteringHelper.getTrainingColors(img, trainingsSize, ColorDifferenceMeasure.RGBEuclidean, (Integer)1);
    }

    public static RColor[] getTrainingColors(PImage img, Integer trainingsSize, Integer cellSize) {
        return ClusteringHelper.getTrainingColors(img, trainingsSize, ColorDifferenceMeasure.RGBEuclidean, (Integer)1);
    }

    public static RColor[] getTrainingColors(PImage img, Integer trainingsSize, ColorDifferenceMeasure m) {
        return ClusteringHelper.getTrainingColors(img, trainingsSize, m, (Integer)1);
    }

    public static RColor[] getTrainingColors(PImage img, Integer trainingsSize, ColorSpace space) {
        return ClusteringHelper.getTrainingColors(img, trainingsSize, space.toColorDifferenceMeasure(), (Integer)1);
    }

    public static RColor[] getTrainingColors(PImage img, Integer trainingsSize, ColorSpace space, int cellSize) {
        return ClusteringHelper.getTrainingColors(img, trainingsSize, space.toColorDifferenceMeasure(), (Integer)cellSize);
    }

    public static RColor[] getTrainingColors(PImage img, Integer trainingsSize, ColorDifferenceMeasure m, Integer cellSize) {
        RColor[] colors = new RColor[trainingsSize.intValue()];
        ColorSpace space = m.toColorSpace();
        int elementsPerCell = cellSize < 1 ? 1 : cellSize;
        TableGrid grid = GridMaker.createTable(0.0f, 0.0f, img.width, img.height, trainingsSize / elementsPerCell);
        img.loadPixels();
        int i = 0;
        while (i < grid.size()) {
            int j = 0;
            while (j < elementsPerCell) {
                float x = grid.getX(i).floatValue() + RMath.random(-0.5f, 0.5f) * grid.cellWidth().floatValue();
                float y = grid.getY(i).floatValue() + RMath.random(-0.5f, 0.5f) * grid.cellHeight().floatValue();
                int index = (int)y * img.width + (int)x;
                colors[i * elementsPerCell + j] = RGBColor.toRGB(img.pixels[index]);
                colors[i * elementsPerCell + j] = ColorHelper.convert(colors[i * elementsPerCell + j], space);
                ++j;
            }
            ++i;
        }
        i = grid.size() * elementsPerCell;
        while (i < colors.length) {
            int ci = RMath.random(img.pixels.length);
            colors[i] = RGBColor.toRGB(img.pixels[ci]);
            colors[i] = ColorHelper.convert(colors[i], space);
            ++i;
        }
        return colors;
    }

    public static RColor[] getTrainingColors(RColor[] colors, Integer trainingsSize) {
        return ClusteringHelper.getTrainingColors(colors, trainingsSize, ColorDifferenceMeasure.RGBEuclidean);
    }

    public static RColor[] getTrainingColors(RColor[] colors, Integer trainingsSize, ColorSpace space) {
        return ClusteringHelper.getTrainingColors(colors, trainingsSize, space.toColorDifferenceMeasure());
    }

    public static RColor[] getTrainingColors(RColor[] colors, Integer trainingSize, ColorDifferenceMeasure m) {
        Object[] o = ClusteringHelper.getTrainingData(colors, trainingSize);
        RColor[] shuffled = (RColor[])Arrays.copyOf(o, o.length, RColor[].class);
        if (m != null) {
            ColorHelper.convert(shuffled, m.toColorSpace());
        }
        return shuffled;
    }
}

